package com.house365.beans.entity;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class WeChatPermissionTreeEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean root;
    private WeChatPermissionEntity entity;
    private List<WeChatPermissionTreeEntity> childs;

    public WeChatPermissionTreeEntity() {
    }

    public WeChatPermissionTreeEntity(boolean root) {
        this.root = root;
    }

    public WeChatPermissionTreeEntity(WeChatPermissionEntity permissionEntity, boolean root) {
        this.root = root;
        this.entity = permissionEntity;
    }

    public void add(WeChatPermissionEntity permissionEntity) {
        if (entity.getId().intValue() == permissionEntity.getParentId()
                .intValue()) {
            if (childs == null) {
                childs = new LinkedList<WeChatPermissionTreeEntity>();
            }
            childs.add(new WeChatPermissionTreeEntity(permissionEntity, false));
        } else if (childs != null) {
            for (WeChatPermissionTreeEntity child : childs) {
                if (child.getEntity().getId().intValue() == permissionEntity
                        .getParentId().intValue()) {
                    child.add(permissionEntity);
                }
            }
        }
    }

    public List<WeChatPermissionEntity> toList() {
        List<WeChatPermissionEntity> list = new LinkedList<WeChatPermissionEntity>();
        if (root) {
            if (childs != null) {
                for (WeChatPermissionTreeEntity child : childs) {
                    list.addAll(child.toList());
                }
            }
            return list;
        } else {
            list.add(entity);
            if (childs != null) {
                for (WeChatPermissionTreeEntity child : childs) {
                    list.addAll(child.toList());
                }
            }
            return list;
        }
    }

    public List<WeChatPermissionEntity> toShowList() {
        List<WeChatPermissionEntity> list = new LinkedList<WeChatPermissionEntity>();
        if (root) {
            if (childs != null) {
                for (WeChatPermissionTreeEntity child : childs) {
                    list.addAll(child.toShowList());
                }
            }
            return list;
        } else {
            if (childs == null && this.getEntity().getHierarchy() < 1) {
                return list;
            }
            list.add(entity);
            if (childs != null) {
                for (WeChatPermissionTreeEntity child : childs) {
                    list.addAll(child.toShowList());
                }
            }
            return list;
        }
    }

    public boolean isRoot() {
        return root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public WeChatPermissionEntity getEntity() {
        return entity;
    }

    public void setEntity(WeChatPermissionEntity entity) {
        this.entity = entity;
    }

    public List<WeChatPermissionTreeEntity> getChilds() {
        return childs;
    }

    public void setChilds(List<WeChatPermissionTreeEntity> childs) {
        this.childs = childs;
    }

}
