/**
 * Description: 角色权限关联数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-22 上午 11:32:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-22   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * 角色权限关联数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-22
 * @see
 * @since 1.0
 */
public class UserRoleEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 用户ID
     */
    @NotNull
    private Integer userId;

    /**
     * 角色ID
     */
    @NotNull
    private Integer roleId;

    private String roleCode;
    private String roleName;

    /**
     * 创建时间
     */
    private java.util.Date createTime;

    /**
     * 创建人用户ID
     */
    private Integer createUserId;

    //columns END


    /**
     * 设置用户ID
     * @param userId 用户ID
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取用户ID
     * @return 用户ID
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置角色ID
     * @param roleId 角色ID
     */
    public void setRoleId(Integer roleId) {
        this.roleId = roleId;
    }


    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    /**
     * 获取角色ID
     * @return 角色ID
     */
    public Integer getRoleId() {
        return this.roleId;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建人用户ID
     * @param createUserId 创建人用户ID
     */
    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 获取创建人用户ID
     * @return 创建人用户ID
     */
    public Integer getCreateUserId() {
        return this.createUserId;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("UserId", getUserId())
                .append("RoleId", getRoleId())
                .append("CreateTime", getCreateTime())
                .append("CreateUserId", getCreateUserId())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UserRoleEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UserRoleEntity other = (UserRoleEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

