/**
 * Description: 抢客客户信息数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-04 上午 10:12:41
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-04   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 抢客客户信息数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-04
 * @see
 * @since 1.0
 */
public class RushCustomerEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 姓名
     */
    @NotBlank
    @Length(max = 250, message = "长度需要大于0且小于250")
    private String name;

    /**
     * 手机
     */
    @NotBlank
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String phone;

    /**
     * 备用号码1
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone1;

    /**
     * 备用号码2
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone2;

    /**
     * 备用号码3
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone3;

    /**
     * 1 男 0 女 2 未知
     */

    private Integer sex;

    /**
     * 1 线上 2 线下
     */
    @NotNull
    private Integer customerType;

    /**
     * 活动来源－CRM
     */
    @NotBlank
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String actSource;

    /**
     * 初次来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String firstSource;

    /**
     * 最近来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String latestSource;

    /**
     * 最近回访纪录－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCall;

    /**
     * 最近回访结果－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCallResult;

    /**
     * 客户状态
     */

    private Integer status;

    /**
     * 创建来源 CRM SYSTEM
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String createSource;

    /**
     * 创建日期
     */
    @NotNull
    private java.util.Date createTime;

    /**
     * 创建人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 购房意向－CRM 3 高 2 中 1低
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String buyIntention;

    /**
     * 最后到访日期
     */

    private java.util.Date lastVisitTime;

    /**
     * 最后回访日期
     */

    private java.util.Date lastCallTime;

    /**
     * 客户经理ID
     */

    private Integer managerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    /**
     * 更新日期
     */
    @NotNull
    private java.util.Date updateTime;

    /**
     * 最后修改人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    /**
     * 城市
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityCode;

    /**
     * 业务条口
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bizPort;

    /**
     * CRM id
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String crmId;

    /**
     * 城市名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityName;

    /**
     * 活动来源ID
     */

    private Integer actSourceId;

    /**
     * 规则id
     */

    private Integer ruleId;

    /**
     * 抢客状态  0：待抢；1：已抢；2：不抢；
     */

    private Integer rushStatus;

    /**
     * 备注
     */
    @Length(max = 600, message = "长度需要大于0且小于600")
    private String remark;

    /**
     * 项目id
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String projectId;

    /**
     * 项目名称
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String projectName;

    private Integer managerCount;

    private Integer isDeleted;

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getManagerCount() {
        return managerCount;
	}

	public void setManagerCount(Integer managerCount) {
        this.managerCount = managerCount;
    }
    //columns END
    /*
	public RushCustomer(){
	}

	public RushCustomer(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取姓名
     *
     * @return 姓名
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置姓名
     *
     * @param name 姓名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取手机
     *
     * @return 手机
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * 设置手机
     *
     * @param phone 手机
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 获取备用号码1
     *
     * @return 备用号码1
     */
    public String getBakPhone1() {
        return this.bakPhone1;
    }

    /**
     * 设置备用号码1
     *
     * @param bakPhone1 备用号码1
     */
    public void setBakPhone1(String bakPhone1) {
        this.bakPhone1 = bakPhone1;
    }

    /**
     * 获取备用号码2
     * @return 备用号码2
     */
    public String getBakPhone2() {
        return this.bakPhone2;
    }

    /**
     * 设置备用号码2
     *
     * @param bakPhone2 备用号码2
     */
    public void setBakPhone2(String bakPhone2) {
        this.bakPhone2 = bakPhone2;
    }

    /**
     * 获取备用号码3
     * @return 备用号码3
     */
    public String getBakPhone3() {
        return this.bakPhone3;
    }

    /**
     * 设置备用号码3
     * @param bakPhone3 备用号码3
     */
    public void setBakPhone3(String bakPhone3) {
        this.bakPhone3 = bakPhone3;
    }

    /**
     * 获取1 男 0 女 2 未知
     * @return 1 男 0 女 2 未知
     */
    public Integer getSex() {
        return this.sex;
    }

    /**
     * 设置1 男 0 女 2 未知
     *
     * @param sex 1 男 0 女 2 未知
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 获取1 线上 2 线下
     *
     * @return 1 线上 2 线下
     */
    public Integer getCustomerType() {
        return this.customerType;
    }

    /**
     * 设置1 线上 2 线下
     * @param customerType 1 线上 2 线下
     */
    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    /**
     * 获取活动来源－CRM
     * @return 活动来源－CRM
     */
    public String getActSource() {
        return this.actSource;
    }

    /**
     * 设置活动来源－CRM
     * @param actSource 活动来源－CRM
     */
    public void setActSource(String actSource) {
        this.actSource = actSource;
    }

    /**
     * 获取初次来源-CRM
     * @return 初次来源-CRM
     */
    public String getFirstSource() {
        return this.firstSource;
    }

    /**
     * 设置初次来源-CRM
     *
     * @param firstSource 初次来源-CRM
     */
    public void setFirstSource(String firstSource) {
        this.firstSource = firstSource;
    }

    /**
     * 获取最近来源-CRM
     * @return 最近来源-CRM
     */
    public String getLatestSource() {
        return this.latestSource;
    }

    /**
     * 设置最近来源-CRM
     *
     * @param latestSource 最近来源-CRM
     */
    public void setLatestSource(String latestSource) {
        this.latestSource = latestSource;
    }

    /**
     * 获取最近回访纪录－CRM
     * @return 最近回访纪录－CRM
     */
    public String getCrmLatestCall() {
        return this.crmLatestCall;
    }

    /**
     * 设置最近回访纪录－CRM
     *
     * @param crmLatestCall 最近回访纪录－CRM
     */
    public void setCrmLatestCall(String crmLatestCall) {
        this.crmLatestCall = crmLatestCall;
    }

    /**
     * 获取最近回访结果－CRM
     * @return 最近回访结果－CRM
     */
    public String getCrmLatestCallResult() {
        return this.crmLatestCallResult;
    }

    /**
     * 设置最近回访结果－CRM
     * @param crmLatestCallResult 最近回访结果－CRM
     */
    public void setCrmLatestCallResult(String crmLatestCallResult) {
        this.crmLatestCallResult = crmLatestCallResult;
    }

    /**
     * 获取客户状态
     *
     * @return 客户状态
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置客户状态
     *
     * @param status 客户状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取创建来源 CRM SYSTEM
     *
     * @return 创建来源 CRM SYSTEM
     */
    public String getCreateSource() {
        return this.createSource;
    }

    /**
     * 设置创建来源 CRM SYSTEM
     *
     * @param createSource 创建来源 CRM SYSTEM
     */
    public void setCreateSource(String createSource) {
        this.createSource = createSource;
    }

    /**
     * 设置创建日期字符串格式
     *
     * @param createTime 创建日期
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建日期
     *
     * @return 创建日期
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建日期
     *
     * @param createTime 创建日期
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取创建人
     * @return 创建人
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置创建人
     *
     * @param creater 创建人
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取购房意向－CRM 3 高 2 中 1低
     *
     * @return 购房意向－CRM 3 高 2 中 1低
     */
    public String getBuyIntention() {
        return this.buyIntention;
    }

    /**
     * 设置购房意向－CRM 3 高 2 中 1低
     * @param buyIntention 购房意向－CRM 3 高 2 中 1低
     */
    public void setBuyIntention(String buyIntention) {
        this.buyIntention = buyIntention;
    }

    /**
     * 设置最后到访日期字符串格式
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTimeStr(String lastVisitTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastVisitTime)) {
            try {
                this.lastVisitTime = java.text.DateFormat.getDateTimeInstance().parse(lastVisitTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后到访日期
     *
     * @return 最后到访日期
     */
    public java.util.Date getLastVisitTime() {
        return this.lastVisitTime;
    }

    /**
     * 设置最后到访日期
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTime(java.util.Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    /**
     * 设置最后回访日期字符串格式
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTimeStr(String lastCallTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastCallTime)) {
            try {
                this.lastCallTime = java.text.DateFormat.getDateTimeInstance().parse(lastCallTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后回访日期
     * @return 最后回访日期
     */
    public java.util.Date getLastCallTime() {
        return this.lastCallTime;
    }

    /**
     * 设置最后回访日期
     *
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTime(java.util.Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    /**
     * 获取客户经理ID
     *
     * @return 客户经理ID
     */
    public Integer getManagerId() {
        return this.managerId;
    }

    /**
     * 设置客户经理ID
     *
     * @param managerId 客户经理ID
     */
    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取客户经理姓名
     *
     * @return 客户经理姓名
     */
    public String getManagerName() {
        return this.managerName;
    }

    /**
     * 设置客户经理姓名
     *
     * @param managerName 客户经理姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 设置更新日期字符串格式
     * @param updateTime 更新日期
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新日期
     * @return 更新日期
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置更新日期
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后修改人
     *
     * @return 最后修改人
     */
    public String getUpdater() {
        return this.updater;
    }

    /**
     * 设置最后修改人
     *
     * @param updater 最后修改人
     */
    public void setUpdater(String updater) {
        this.updater = updater;
    }

    /**
     * 获取城市
     * @return 城市
     */
    public String getCityCode() {
        return this.cityCode;
    }

    /**
     * 设置城市
     * @param cityCode 城市
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /**
     * 获取业务条口
     * @return 业务条口
     */
    public String getBizPort() {
        return this.bizPort;
    }

    /**
     * 设置业务条口
     *
     * @param bizPort 业务条口
     */
    public void setBizPort(String bizPort) {
        this.bizPort = bizPort;
    }

    /**
     * 获取CRM id
     * @return CRM id
     */
    public String getCrmId() {
        return this.crmId;
    }

    /**
     * 设置CRM id
     *
     * @param crmId CRM id
     */
    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    /**
     * 获取城市名
     *
     * @return 城市名
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置城市名
     *
     * @param cityName 城市名
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取活动来源ID
     *
     * @return 活动来源ID
     */
    public Integer getActSourceId() {
        return this.actSourceId;
    }

    /**
     * 设置活动来源ID
     *
     * @param actSourceId 活动来源ID
     */
    public void setActSourceId(Integer actSourceId) {
        this.actSourceId = actSourceId;
    }

    /**
     * 获取规则id
     *
     * @return 规则id
     */
    public Integer getRuleId() {
        return this.ruleId;
    }

    /**
     * 设置规则id
     *
     * @param ruleId 规则id
     */
    public void setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * 获取抢客状态  0：待抢；1：已抢；2：不抢；
     *
     * @return 抢客状态  0：待抢；1：已抢；2：不抢；
     */
    public Integer getRushStatus() {
        return this.rushStatus;
    }

    /**
     * 设置抢客状态  0：待抢；1：已抢；2：不抢；
     * @param rushStatus 抢客状态  0：待抢；1：已抢；2：不抢；
     */
    public void setRushStatus(Integer rushStatus) {
        this.rushStatus = rushStatus;
    }

    /**
     * 获取备注
     *
     * @return 备注
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取项目id
     *
     * @return 项目id
     */
    public String getProjectId() {
        return this.projectId;
    }

    /**
     * 设置项目id
     *
     * @param projectId 项目id
     */
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取项目名称
     *
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

	/**
	 * 设置项目名称
	 * @param projectName 项目名称
	 */
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("Name",getName())
			.append("Phone",getPhone())
			.append("BakPhone1",getBakPhone1())
			.append("BakPhone2",getBakPhone2())
			.append("BakPhone3",getBakPhone3())
			.append("Sex",getSex())
			.append("CustomerType",getCustomerType())
			.append("ActSource",getActSource())
                .append("FirstSource", getFirstSource())
                .append("LatestSource", getLatestSource())
			.append("CrmLatestCall", getCrmLatestCall())
			.append("CrmLatestCallResult",getCrmLatestCallResult())
			.append("Status",getStatus())
			.append("CreateSource",getCreateSource())
			.append("CreateTime",getCreateTime())
			.append("Creater",getCreater())
			.append("BuyIntention",getBuyIntention())
			.append("LastVisitTime",getLastVisitTime())
			.append("LastCallTime",getLastCallTime())
			.append("ManagerId",getManagerId())
			.append("ManagerName",getManagerName())
			.append("UpdateTime",getUpdateTime())
			.append("Updater",getUpdater())
			.append("CityCode",getCityCode())
			.append("BizPort",getBizPort())
			.append("CrmId",getCrmId())
			.append("CityName",getCityName())
			.append("ActSourceId",getActSourceId())
			.append("RuleId",getRuleId())
			.append("RushStatus",getRushStatus())
			.append("Remark",getRemark())
                .append("ProjectId",getProjectId())
			.append("ProjectName",getProjectName())
			.toString();
	}

	/**
     * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
     * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof RushCustomerEntity == false) return false;
		if(this == obj) return true;
		RushCustomerEntity other = (RushCustomerEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

