/**
 * Description: 客户信息数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.house365.beans.system.DomainObject;
import com.house365.beans.vo.CustomerProjectStatusProgressVo;
import com.house365.web.util.DateTimeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 客户信息数据库实体/领域对象<br>
 * 私客列表去customer_merge,customer表存放所有客户数据
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public class CustomerEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String name;

    private String labelId;

    private String showPlatCreater;

    private String platCustomerStatus;

    private boolean protectPeriod;

    private String projectId;

    private String channel;

    private Integer userId;

    private Integer totalNum;

    private String markedLabelId;

    public String getShowPlatCreater() {
        return showPlatCreater;
    }

    public void setShowPlatCreater(String showPlatCreater) {
        this.showPlatCreater = showPlatCreater;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getLabelId() {
        return labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    private String star;

    public String getStar() {
        return star;
    }

    public void setStar(String star) {
        this.star = star;
    }

    public String getMarkedLabelId() {
        return markedLabelId;
    }

    public void setMarkedLabelId(String markedLabelId) {
        this.markedLabelId = markedLabelId;
    }

    public String getPlatCustomerStatus() {
        return platCustomerStatus;
    }

    public void setPlatCustomerStatus(String platCustomerStatus) {
        this.platCustomerStatus = platCustomerStatus;
    }

    /**
     * phone
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String phone;

    private String belongToday;
    private String belongYestoday;
    private String belongSince;

    private String lastJoinVisitRemark;
    private String lastJoinVisitWorker;
    private String lastJoinVisitTime;
    private String protectMsg;

    public String getProtectMsg() {
        return protectMsg;
    }

    public void setProtectMsg(String protectMsg) {
        this.protectMsg = protectMsg;
    }

    public boolean isProtectPeriod() {
        return protectPeriod;
    }

    public void setProtectPeriod(boolean protectPeriod) {
        this.protectPeriod = protectPeriod;
    }

    /**
     * bakPhone1
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone1;

    /**
     * bakPhone2
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone2;

    /**
     * bakPhone3
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone3;

    /**
     * 1 男 0 女 2 未知
     */
    private Integer sex;

    /**
     * 1 线上 2 线下
     */
    @NotNull
    private Integer customerType;

    /**
     * 活动来源
     */
    @NotBlank
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String actSource;

    /**
     * 初次来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String firstSource;

    /**
     * 最近来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String latestSource;

    /**
     * 最近回访纪录－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCall;

    /**
     * 最近回访结果－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCallResult;

    /**
     * 客户状态 一般 都是0 未约看 400电话过来的客户为99 未跟踪，我的客户列表不展示，已跟踪客户置为0，微信端已删除客户置为99,400已删除仍然展示在我的客户中,98表示未跟踪
     */
    private Integer status;

    /**
     * 创建来源 CRM SYSTEM
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String createSource;

    /**
     * 创建日期
     */
    @NotNull
    private Date createTime;

    /**
     * 创建人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 创建人Id
     */
    private Integer createrId;

    /**
     * 购房意向－CRM
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String buyIntention;

    /**
     * 最后到访日期
     */
    private Date lastVisitTime;

    /**
     * 最后回访日期
     */
    private Date lastCallTime;

    /**
     * 客户经理ID
     */
    private Integer managerId;

    private Integer oldManagerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    private String oldManagerName;

    /**
     * 更新日期
     */
    @NotNull
    private Date updateTime;

    /**
     * 最后修改人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    @Length(max = 45, message = "长度需要大于0且小于45")
    @NotNull
    private String cityCode;

    @Length(max = 45, message = "长度需要大于0且小于45")
    @NotNull
    private String cityName;

    //业务条口
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bizPort;

    @Length(max = 45, message = "长度需要大于0且小于45")
    private String crmId;

    private Integer actSourceId;

    private List<String> projectNames;

    private List<CustomerProjectEntity> cps;

    /**
     * 跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     */
    private Integer traceStatus;

    //CRM推送状态 1 已推送 0 未推送
    private String crmSync;

    //IM咨询客户新一轮进线周期
    private String newCycle;

    //yyyy-mm-dd hh:hh:ss
    private String createTimeStr;
    //yyyy-mm-dd
    private String createDateStr;

    //400来电时间
    private Date hotlineCallTime;

    //400来电时长
    private String hotlineCallSpend;
    /**
     * 备注
     */
    @Length(max = 140, message = "长度需要大于0且小于140")
    private String remark;

    //回公海时间
    private Date oceanDate;

    //是否删除 - 公海
    private Integer isDelete;

    //原置业顾问 - 回公海前
    private String lastManager;

    //会员与置业顾问绑定时间
    private Date bindTime;

    /**
     * 客户来源类型 1：常规；3：营销；2：抢客；
     */
    private Integer customerSourceType;

    /**
     * 其他公海关联键
     */
    private Integer customerRelId;

    //报名时间 营销客户派工时设置
    private String singupTime;

    //是否营销类型派工待回访数据，添加回访记录后设置为否
    private Integer isWaitCall;

    private Integer marketActId;

    private String marketActName;

    //是否重客，方便页面查看，非数据库字段
    private int isRepeat;
    //主客id，列表使用需要
    private int majorId;
    //是否同行
    private int isPeer;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date returnRemindTime;

    // 是否星标客户
    private int starCustomer;

    // 是否标星平台用户
    private int starPtCustomer;

    private int isActive;

    private Date activeTime;

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getOldManagerId() {
        return oldManagerId;
    }

    public void setOldManagerId(Integer oldManagerId) {
        this.oldManagerId = oldManagerId;
    }

    public String getOldManagerName() {
        return oldManagerName;
    }

    public void setOldManagerName(String oldManagerName) {
        this.oldManagerName = oldManagerName;
    }

    public String getNewCycle() {
        return newCycle;
    }

    public void setNewCycle(String newCycle) {
        this.newCycle = newCycle;
    }

    public String getSingupTime() {
        return singupTime;
    }

    public void setSingupTime(String singupTime) {
        this.singupTime = singupTime;
    }

    public Integer getMarketActId() {
        return marketActId;
    }

    public void setMarketActId(Integer marketActId) {
        this.marketActId = marketActId;
    }

    public String getMarketActName() {
        return marketActName;
    }

    public void setMarketActName(String marketActName) {
        this.marketActName = marketActName;
    }

    public Integer getIsWaitCall() {
        return isWaitCall;
    }

    public void setIsWaitCall(Integer isWaitCall) {
        this.isWaitCall = isWaitCall;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getLastManager() {
        return lastManager;
    }

    public void setLastManager(String lastManager) {
        this.lastManager = lastManager;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public int getStarPtCustomer() {
        return starPtCustomer;
    }

    public void setStarPtCustomer(int starPtCustomer) {
        this.starPtCustomer = starPtCustomer;
    }


    public Integer getCreaterId() {
        return createrId;
    }

    public void setCreaterId(Integer createrId) {
        this.createrId = createrId;
    }

    /**
     * 设置创建日期字符串格式
     *
     * @param createTime 创建日期
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            this.createTime = DateTimeUtils.parseDate(createTime, "yyyy-MM-dd HH:mm:ss");
            this.createTimeStr = createTime;
        }
    }

    public Date getOceanDate() {
        return oceanDate;
    }

    public void setOceanDate(Date oceanDate) {
        this.oceanDate = oceanDate;
    }

    public String getCrmSync() {
        return crmSync;
    }

    public void setCrmSync(String crmSync) {
        this.crmSync = crmSync;
    }

    public Integer getActSourceId() {
        return actSourceId;
    }

    public void setActSourceId(Integer actSourceId) {
        this.actSourceId = actSourceId;
    }

    public List<CustomerProjectEntity> getCps() {
        return cps;
    }

    public void setCps(List<CustomerProjectEntity> cps) {
        this.cps = cps;
    }

    public List<String> getProjectNames() {
        return projectNames;
    }

    public void setProjectNames(List<String> projectNames) {
        this.projectNames = projectNames;
    }

    public String getCrmId() {
        return crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getBizPort() {
        return bizPort;
    }

    //columns END

    public void setBizPort(String bizPort) {
        this.bizPort = bizPort;
    }

    /**
     * 获取name
     *
     * @return name
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置name
     *
     * @param name name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取phone
     *
     * @return phone
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * 设置phone
     *
     * @param phone phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 获取bakPhone1
     *
     * @return bakPhone1
     */
    public String getBakPhone1() {
        return this.bakPhone1;
    }

    /**
     * 设置bakPhone1
     *
     * @param bakPhone1 bakPhone1
     */
    public void setBakPhone1(String bakPhone1) {
        this.bakPhone1 = bakPhone1;
    }

    /**
     * 获取bakPhone2
     *
     * @return bakPhone2
     */
    public String getBakPhone2() {
        return this.bakPhone2;
    }

    /**
     * 设置bakPhone2
     *
     * @param bakPhone2 bakPhone2
     */
    public void setBakPhone2(String bakPhone2) {
        this.bakPhone2 = bakPhone2;
    }

    /**
     * 获取bakPhone3
     *
     * @return bakPhone3
     */
    public String getBakPhone3() {
        return this.bakPhone3;
    }

    /**
     * 设置bakPhone3
     *
     * @param bakPhone3 bakPhone3
     */
    public void setBakPhone3(String bakPhone3) {
        this.bakPhone3 = bakPhone3;
    }

    /**
     * 获取1 男 0 女 2 未知
     *
     * @return 1 男 0 女 2 未知
     */
    public Integer getSex() {
        return this.sex;
    }

    /**
     * 设置1 男 0 女 2 未知
     *
     * @param sex 1 男 0 女 2 未知
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 获取1 线上 2 线下
     *
     * @return 1 线上 2 线下
     */
    public Integer getCustomerType() {
        return this.customerType;
    }

    /**
     * 设置1 线上 2 线下
     *
     * @param customerType 1 线上 2 线下
     */
    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    /**
     * 获取活动来源
     *
     * @return 活动来源
     */
    public String getActSource() {
        return this.actSource;
    }

    /**
     * 设置活动来源
     *
     * @param actSource 活动来源
     */
    public void setActSource(String actSource) {
        this.actSource = actSource;
    }

    /**
     * 获取初次来源-CRM
     *
     * @return 初次来源-CRM
     */
    public String getFirstSource() {
        return this.firstSource;
    }

    /**
     * 设置初次来源-CRM
     *
     * @param firstSource 初次来源-CRM
     */
    public void setFirstSource(String firstSource) {
        this.firstSource = firstSource;
    }

    /**
     * 获取最近来源-CRM
     *
     * @return 最近来源-CRM
     */
    public String getLatestSource() {
        return this.latestSource;
    }

    /**
     * 设置最近来源-CRM
     *
     * @param latestSource 最近来源-CRM
     */
    public void setLatestSource(String latestSource) {
        this.latestSource = latestSource;
    }

    /**
     * 获取最近回访纪录－CRM
     *
     * @return 最近回访纪录－CRM
     */
    public String getCrmLatestCall() {
        return this.crmLatestCall;
    }

    /**
     * 设置最近回访纪录－CRM
     *
     * @param crmLatestCall 最近回访纪录－CRM
     */
    public void setCrmLatestCall(String crmLatestCall) {
        this.crmLatestCall = crmLatestCall;
    }

    /**
     * 获取最近回访结果－CRM
     *
     * @return 最近回访结果－CRM
     */
    public String getCrmLatestCallResult() {
        return this.crmLatestCallResult;
    }

    /**
     * 设置最近回访结果－CRM
     *
     * @param crmLatestCallResult 最近回访结果－CRM
     */
    public void setCrmLatestCallResult(String crmLatestCallResult) {
        this.crmLatestCallResult = crmLatestCallResult;
    }

    /**
     * 获取客户状态
     *
     * @return 客户状态
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置客户状态
     *
     * @param status 客户状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取创建来源 CRM SYSTEM
     *
     * @return 创建来源 CRM SYSTEM
     */
    public String getCreateSource() {
        return this.createSource;
    }

    /**
     * 设置创建来源 CRM SYSTEM
     *
     * @param createSource 创建来源 CRM SYSTEM
     */
    public void setCreateSource(String createSource) {
        this.createSource = createSource;
    }

    /**
     * 获取创建日期
     *
     * @return 创建日期
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建日期
     *
     * @param createTime 创建日期
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取创建人
     *
     * @return 创建人
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置创建人
     *
     * @param creater 创建人
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取购房意向－CRM
     *
     * @return 购房意向－CRM
     */
    public String getBuyIntention() {
        return this.buyIntention;
    }

    /**
     * 设置购房意向－CRM
     *
     * @param buyIntention 购房意向－CRM
     */
    public void setBuyIntention(String buyIntention) {
        this.buyIntention = buyIntention;
    }

    /**
     * 设置最后到访日期字符串格式
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTimeStr(String lastVisitTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastVisitTime)) {
            try {
                this.lastVisitTime = java.text.DateFormat.getDateTimeInstance().parse(lastVisitTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后到访日期
     *
     * @return 最后到访日期
     */
    public java.util.Date getLastVisitTime() {
        return this.lastVisitTime;
    }

    /**
     * 设置最后到访日期
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTime(java.util.Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    /**
     * 设置最后回访日期字符串格式
     *
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTimeStr(String lastCallTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastCallTime)) {
            try {
                this.lastCallTime = java.text.DateFormat.getDateTimeInstance().parse(lastCallTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后回访日期
     *
     * @return 最后回访日期
     */
    public java.util.Date getLastCallTime() {
        return this.lastCallTime;
    }

    /**
     * 设置最后回访日期
     *
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTime(java.util.Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    /**
     * 获取客户经理ID
     *
     * @return 客户经理ID
     */
    public Integer getManagerId() {
        return this.managerId;
    }

    /**
     * 设置客户经理ID
     *
     * @param managerId 客户经理ID
     */
    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取客户经理姓名
     *
     * @return 客户经理姓名
     */
    public String getManagerName() {
        return this.managerName;
    }

    /**
     * 设置客户经理姓名
     *
     * @param managerName 客户经理姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 设置更新日期字符串格式
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新日期
     *
     * @return 更新日期
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置更新日期
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后修改人
     *
     * @return 最后修改人
     */
    public String getUpdater() {
        return this.updater;
    }

    /**
     * 设置最后修改人
     *
     * @param updater 最后修改人
     */
    public void setUpdater(String updater) {
        this.updater = updater;
    }

    /**
     * 获取跟踪状态
     *
     * @return 跟踪状态
     */
    public Integer getTraceStatus() {
        return this.traceStatus;
    }

    /**
     * 设置跟踪状态
     *
     * @param traceStatus 跟踪状态
     */
    public void setTraceStatus(Integer traceStatus) {
        this.traceStatus = traceStatus;
    }

    public String getCreateDateStr() {
        return createDateStr;
    }

    public void setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
    }

    /**
     * 获取备注
     *
     * @return 备注
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getHotlineCallTime() {
        return hotlineCallTime;
    }

    public void setHotlineCallTime(Date hotlineCallTime) {
        this.hotlineCallTime = hotlineCallTime;
    }

    public String getHotlineCallSpend() {
        return hotlineCallSpend;
    }

    public void setHotlineCallSpend(String hotlineCallSpend) {
        this.hotlineCallSpend = hotlineCallSpend;
    }

    public Date getBindTime() {
        return bindTime;
    }

    public void setBindTime(Date bindTime) {
        this.bindTime = bindTime;
    }

    public Integer getCustomerSourceType() {
        return customerSourceType;
    }

    public void setCustomerSourceType(Integer customerSourceType) {
        this.customerSourceType = customerSourceType;
    }

    public Integer getCustomerRelId() {
        return customerRelId;
    }

    public void setCustomerRelId(Integer customerRelId) {
        this.customerRelId = customerRelId;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                getName()).append(
                "Phone", getPhone()).append("BakPhone1", getBakPhone1()).append("BakPhone2", getBakPhone2()).append(
                "BakPhone3", getBakPhone3()).append("Sex", getSex()).append("CustomerType", getCustomerType()).append(
                "ActSource", getActSource()).append("FirstSource", getFirstSource()).append("LatestSource",
                getLatestSource()).append(
                "CrmLatestCall", getCrmLatestCall()).append("CrmLatestCallResult", getCrmLatestCallResult()).append(
                "Status", getStatus()).append("CreateSource", getCreateSource()).append("CreateTime",
                getCreateTime()).append("Creater",
                getCreater()).append(
                "BuyIntention", getBuyIntention()).append("LastVisitTime", getLastVisitTime()).append("LastCallTime",
                getLastCallTime()).append(
                "ManagerId", getManagerId()).append("ManagerName", getManagerName()).append("UpdateTime",
                getUpdateTime()).append(
                "Updater", getUpdater()).append("CityCode", getCityCode()).append("BizPort", getBizPort()).append("CrmId",
                getCrmId()).append(
                "CityName", getCityName()).append("ActSourceId", getActSourceId()).append("TraceStatus",
                getTraceStatus()).append("Remark", getRemark()).append("LabelId", getLabelId()).append("UserId", getUserId()).append("BelongToday", getBelongToday())
                .append("BelongYestoday", getBelongYestoday()).append("BelongSince", getBelongSince()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CustomerEntity other = (CustomerEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    public int getIsRepeat() {
        return isRepeat;
    }

    public void setIsRepeat(int isRepeat) {
        this.isRepeat = isRepeat;
    }

    public int getMajorId() {
        return majorId;
    }

    public void setMajorId(int majorId) {
        this.majorId = majorId;
    }

    public int getIsPeer() {
        return isPeer;
    }

    public void setIsPeer(int isPeer) {
        this.isPeer = isPeer;
    }

    public Date getReturnRemindTime() {
        return returnRemindTime;
    }

    public void setReturnRemindTime(Date returnRemindTime) {
        this.returnRemindTime = returnRemindTime;
    }

    public int getStarCustomer() {
        return starCustomer;
    }

    public void setStarCustomer(int starCustomer) {
        this.starCustomer = starCustomer;
    }

    /**
     * 是否为被交接过的客户
     */
    private int isHandover;

    public int getIsHandover() {
        return isHandover;
    }

    public void setIsHandover(int isHandover) {
        this.isHandover = isHandover;
    }

    /**
     * 是否为系统回收的客户
     */
    private int isRecycled;

    public int getIsRecycled() {
        return isRecycled;
    }

    public void setIsRecycled(int isRecycled) {
        this.isRecycled = isRecycled;
    }

    private CustomerProjectStatusProgressVo statusProgress;

    public CustomerProjectStatusProgressVo getStatusProgress() {
        return statusProgress;
    }

    public void setStatusProgress(CustomerProjectStatusProgressVo statusProgress) {
        this.statusProgress = statusProgress;
    }

    public String getLastJoinVisitRemark() {
        return lastJoinVisitRemark;
    }

    public void setLastJoinVisitRemark(String lastJoinVisitRemark) {
        this.lastJoinVisitRemark = lastJoinVisitRemark;
    }

    public String getLastJoinVisitWorker() {
        return lastJoinVisitWorker;
    }

    public void setLastJoinVisitWorker(String lastJoinVisitWorker) {
        this.lastJoinVisitWorker = lastJoinVisitWorker;
    }

    public String getLastJoinVisitTime() {
        return lastJoinVisitTime;
    }

    public void setLastJoinVisitTime(String lastJoinVisitTime) {
        this.lastJoinVisitTime = lastJoinVisitTime;
    }

    public String getBelongToday() {
        return belongToday;
    }

    public void setBelongToday(String belongToday) {
        this.belongToday = belongToday;
    }

    public String getBelongYestoday() {
        return belongYestoday;
    }

    public void setBelongYestoday(String belongYestoday) {
        this.belongYestoday = belongYestoday;
    }

    public String getBelongSince() {
        return belongSince;
    }

    public void setBelongSince(String belongSince) {
        this.belongSince = belongSince;
    }

    public int getIsActive() {
        return isActive;
    }

    public void setIsActive(int isActive) {
        this.isActive = isActive;
    }

    public Date getActiveTime() {
        return activeTime;
    }

    public void setActiveTime(Date activeTime) {
        this.activeTime = activeTime;
    }
}

