package com.house365.dao.system.impl;

import java.lang.reflect.ParameterizedType;

import java.util.Collection;
import java.util.List;

import com.house365.beans.system.DomainObject;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.dao.system.interfaces.DaoSecondImpl;

/**
 * 默认dao实现<br>
 * 
 */
public class DefaultDaoSecondImpl<T extends DomainObject> extends DaoSecondImpl<T>
        implements Dao<T> {

    /**
     * 获取带命名空间的函数名 <br>
     * 
     * @param clazz
     * @return 返回类型为 ClassName.methodName
     * @see
     */
    public String getStatement(Class<?> clazz) {
        StackTraceElement[] stacks = new Exception().getStackTrace();
        return getStatement(clazz, stacks[1].getMethodName());
    }

    /**
     * 获取带命名空间的函数名<br>
     * 
     * @param clazz
     * @param methodName
     * @return 返回类型为 ClassName.methodName
     * @see
     */
    public String getStatement(Class<?> clazz, String methodName) {
        return clazz.getName() + "." + methodName;
    }

    /**
     * 根据T类型来算出带命名空间的函数名<br>
     * 
     * 
     * @return 返回类型为 ClassName.methodName
     * @see
     */
    public String getStatement() {
        StackTraceElement[] stacks = new Exception().getStackTrace();
        return getStatement(stacks[1].getMethodName());
    }

    /**
     * 根据T类型来算出带命名空间的函数名<br>
     * 
     * 
     * @param methodName
     *            方法名
     * @return 返回类型为 ClassName.methodName
     * @see
     */
    @SuppressWarnings("unchecked")
    public String getStatement(String methodName) {
        ParameterizedType type = ((ParameterizedType) getClass()
                .getGenericSuperclass());
        Class<T> entityClass = (Class<T>) (type.getActualTypeArguments()[0]);
        return getStatement(entityClass, methodName);
    }

    public void delete(Integer id) {
        delete(getStatement(), id);
    }

    public void deleteByIds(Integer... ids) {
        deleteByIds(getStatement(), ids);
    }

    public T getById(Integer id) {
        return this.getEntity(getStatement(), id);
    }

    public int getTotalCount(Object params) {
        return uniqueIntResult(getStatement("queryByPage")
                + COUNT_STATEMENT_SUFFIX, params);
    }

    public List<T> queryByPage(QueryParams<?> queryParams) {
        return this.queryByQueryParams(getStatement(), queryParams);
    }

    public Integer save(T entity) {
        this.save(getStatement(), entity);
        return entity.getId();
    }

    public void update(T entity) {
        this.update(getStatement(), entity);
    }
    
    /**
     * 批量更新
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    public void update(Collection<T> entities) {
        this.batchUpdate(getStatement(), entities);
    }

    public List<T> queryAll() {
        return this.query(getStatement());
    }

    public List<T> queryAll(QueryParams<?> queryParams) {
        return this.query(getStatement(), queryParams);
    }

    /**
     * 批量插入
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    public void save(Collection<T> entities) {
        this.batchSave(getStatement(), entities);
    }
}
