package com.house365.tags;

import java.io.IOException;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class LengthLimterTag extends RequestContextAwareTag {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final Integer DEFAULT_CHAR = 10;
	private static final String SUFFIX = "...";
	// 需要截短的字符串
	private String value = "";
	// 截取长度
	private Integer maxLen = DEFAULT_CHAR;

	public void setValue(String value) {
		this.value = value;
	}

	public void setMaxLen(Integer maxLen) {
		this.maxLen = maxLen;
	}

	@Override
	protected int doStartTagInternal() throws IOException {

		if (StringUtils.isNotBlank(value) && value.length() > maxLen) {
			value = value.substring(0, maxLen) + SUFFIX;
		}
		pageContext.getOut().print(value);
		return SKIP_BODY;
	}

}
