/**
 * Description: 客户信息业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.common.MessageTypeEnum;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.CrmVisitAndSignCustomer;
import com.house365.service.system.Interfaces.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 客户信息业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerService<T extends CustomerEntity> extends Service<T> {

    void sendCustomerToCRMJOB();

    void bindCustomer(CustomerEntity customerEntity, UserEntity user) throws Exception;

    String postToCRM(CustomerEntity customer) throws Exception;

    CustomerEntity createCustomer(CustomerEntity customerEntity, String creator, String userName) throws Exception;

    List<Integer> getSummaryIds(String summaryType, String managerId);

    List<Map<String, Object>> getNewCustomerIds(String managerId);

    List<Map<String, Object>> getTodayUpdateIds(String managerId);

    List<Map<String, Object>> getNocallSevenDayIds(String managerId);

    List<Map<String, Object>> getNocallThreeDayIds(String managerId);

    List<Map<String, Object>> getNoStatusUpdateIds(String managerId);

    List<Map<String, Object>> getNoVisitIdsByDays(Integer days, String city);

    List<Map<String, Object>> getNoPledgedIdsByDays(Integer days, String city);

    Map<String, Object> getSummary(String managerId);

    Map<String, Object> getNewSummary(Map<String, String> summaryParams);

    Map<String, Object> getSummarySimple(String managerId);

    Map<String, Object> getSeaSummary(String managerId);

    //微信我的客户首页统计信息
    Map<String, Object> getWechatMyCucstomerSummary(String managerId);

    //微信我的客户首页统计信息-置业顾问
    List<Map<String, Object>> getWechatMyCucstomerUserView(String managerId, String pageNo, String pageSize);

    //获取最后评论记录，customerIds为逗号隔开，返回customerId和content
    List<Map<String, Object>> getLastestCallback(String customerIds);

    Map<String, Object> getSummaryForCRM(String phone);

    Map<String, Object> getSummary7ForCRM(String phone);

    void updateName();

    void statisticTask();

    void statisticByDay(int day);

    void updateSourceName(String oldName, String name);

    void updateManager(Integer managerId, String managerName);

    void removeFromOcean();

    //今日新增客户
    List<Integer> getNewAddCustomerIds(String managerId);

    //3天内回访的客户
    List<Integer> getCallInThreeDayIds(String managerId);

    //星标客户
    List<Integer> getStarCustomerIds(String managerId);

    //7日新增客户
    List<Integer> getSevenDayNewCustomerIds(String managerId);

    void sendMessageToWechat(MessageTypeEnum type, String toUser, Map<String, String> params);

    void sendMsgToWechat(String msg, int userId, Map<String, String> params);

    List<CustomerEntity> getCustomerManagementList(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getPlatformCustomerList(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getCustomerManagementList4Label(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getCustomerListFromOld(QueryParams<CustomerEntity> queryParams);

    List<CustomerEntity> getWechatCustomers(QueryParams<CustomerEntity> queryParams);

    void backToSeaByStatusOverDaysTask();

    List<Map<String, Object>> getNoCallByHours(Integer hours, String city);

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    void removeCustomer(Integer custmerId, Integer userId, boolean isRecycled) throws Exception;

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    void newRemoveCustomer(Integer managerId, String phone, Integer userId, boolean isRecycled) throws Exception;

    /**
     * 批量转移客户到公海
     *
     * @param customerIds
     * @param userId
     */
    void batchRemoveCustomer(String customerIds, Integer userId, String userName) throws Exception;

    Integer getTotalCall(QueryParams<T> queryParams);

    Integer getTotalCallOptimize(QueryParams<T> queryParams);

    Integer getTotalAbandon(QueryParams<T> queryParams);

    List<Map<String, Object>> getMarketInfo(QueryParams<T> queryParams);

    List<CrmVisitAndSignCustomer> crmVisitAndSignCustomer(Map<String, Object> params);

    List<DictionaryEntity> getNoApproximateConfig(Map<String, Object> map);

    void updateOldCustomers(CustomerEntity customer);
}
