/**
 * Description: BaseTree业务接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-08 下午 15:16:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.BaseTreeEntity;
import com.house365.service.system.Interfaces.Service;

import java.util.List;

/**
 * BaseTree业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-08
 * @see
 * @since 1.0
 */
public interface IBaseTreeService<T extends BaseTreeEntity> extends Service<T> {

    List<BaseTreeEntity> findChildrenListByPath(List<T> parents);

    void clean(String sourceType);

}
