/**
 * Description: UserSourceStatistics业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:36:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.IUserSourceStatisticsDao;
import com.house365.ws.service.interfaces.IUserSourceStatisticsService;
import com.house365.beans.entity.UserSourceStatisticsEntity;

/**
 * UserSourceStatistics业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Service("userSourceStatisticsService")
public class UserSourceStatisticsServiceImpl<T extends UserSourceStatisticsEntity> extends DefaultServiceImpl<T> implements IUserSourceStatisticsService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IUserSourceStatisticsDao<T> userSourceStatisticsDao;

    @Override
    protected Dao<T> getDao() {
        return userSourceStatisticsDao;
    }

    @Override
    public List<Map> statisticCustomer(QueryParams para) {
        return userSourceStatisticsDao.statisticCustomer(para);
    }

    @Override
    public List<Map> statisticCustomerByWeek(QueryParams<T> queryParams) {
        return userSourceStatisticsDao.statisticCustomerByWeek(queryParams);
    }

    @Override
    public List<Map> statisticCustomerByMonth(QueryParams<T> queryParams) {
        return userSourceStatisticsDao.statisticCustomerByMonth(queryParams);
    }


    @Override
    public List<Map> statisticStatusSource(QueryParams para) {
        return userSourceStatisticsDao.statisticStatusSource(para);
    }

    @Override
    public List<Map> statisticStatusSourceByWeek(QueryParams<T> queryParams) {
        return userSourceStatisticsDao.statisticStatusSourceByWeek(queryParams);
    }

    @Override
    public List<Map> statisticStatusSourceByMonth(QueryParams<T> queryParams) {
        return userSourceStatisticsDao.statisticStatusSourceByMonth(queryParams);
    }


    @Override
    public List<Map> transCustomer(QueryParams<T> para) {
        return userSourceStatisticsDao.transCustomer(para);
    }

    @Override
    public List<Map> transCustomerByWeek(QueryParams<T> para) {
        return userSourceStatisticsDao.transCustomerByWeek(para);
    }

    @Override
    public List<Map> transCustomerByMonth(QueryParams<T> para) {
        return userSourceStatisticsDao.transCustomerByMonth(para);
    }

    @Override
    public void updateNames() {
        userSourceStatisticsDao.updateProjectName();
        userSourceStatisticsDao.updateCityName();
        userSourceStatisticsDao.updateSourceName();
    }

    @Override
    public void deleteByDate(String startDateStr) {
        userSourceStatisticsDao.deleteByDate(startDateStr);
    }
}
