/**
 * Description: 账户业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.house365.beans.entity.RequestLoginEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.entity.UserEvaluateEntity;
import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.web.util.SpringContextUtil;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.interfaces.IUserDao;
import com.house365.ws.service.interfaces.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 账户业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("userService")
public class UserServiceImpl<T extends UserEntity> extends DefaultServiceImpl<T> implements IUserService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IUserDao<T> userDao;

    @Override
    protected Dao<T> getDao() {
        return userDao;
    }

    @Override
    public List<String> getMobilesByProject(Integer projectId) {
        return userDao.getMobilesByProject(projectId);
    }

    @Override
    public List<String> getIdsByProject(Integer projectId) {
        return userDao.getIdsByProject(projectId);
    }

    //获取自己和所有下属id
    @Override
    public List<Integer> getUserIdOnPath(Integer parentId) {
        RedisUtilsInterface redisUtils = (RedisUtilsInterface) SpringContextUtil.getBean("redisUtils");
        String key = "userOnPath_" + parentId;
        if (redisUtils.hasKey(key)) {
            String cache = redisUtils.getValByKeyNew(key);
            if (!Strings.isNullOrEmpty(cache)) {
                String[] ids = cache.split(",");
                List<Integer> userIds = new ArrayList<>();
                for (String id : ids) {
                    userIds.add(Integer.parseInt(id));
                }
                return userIds;
            }
        }
        List<Integer> result = userDao.getUserIdOnPath(parentId);
        redisUtils.setValueExpireNew(key, Joiner.on(",").join(result), 1, TimeUnit.MINUTES);
        return result;
    }

    @Override
    public Map<String, Object> getSummary(String managerId) {
        return userDao.getSummary(managerId);
    }


    @Override
    public List queryShortNum4Crm() {
        return userDao.queryShortNum4Crm();
    }

    //按楼盘短号获取直销人员列表
    @Override
    public List<UserEntity> getAccidByName(Map<String, Object> queryMap) {
        return userDao.getAccidByName(queryMap);
    }

    //按楼盘短号获取直销人员列表
    @Override
    public List<UserEntity> getUserByPorjectShort(Map<String, Object> queryMap) {
        return userDao.getUserByPorjectShort(queryMap);
    }

    //查询所有评价信息
    @Override
    public List<UserEvaluateEntity> queryEvaluateListById(UserEvaluateEntity uue) {
        return userDao.queryEvaluateListById(uue);
    }

    @Override
    public void reviewStatus(UserEvaluateEntity uue) {
        userDao.reviewStatus(uue);
    }

    @Override
    public void delEvaluationById(UserEvaluateEntity uue) {
        userDao.delEvaluationById(uue);
    }

    @Override
    public List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams) {
        return userDao.getAppVersionList(queryParams);
    }

    @Override
    public List<RequestLoginEntity> getAuthorizationList(QueryParams<RequestLoginEntity> queryParams) {
        return userDao.getAuthorizationList(queryParams);
    }

    @Override
    public Integer countAuthorizationList(QueryParams<RequestLoginEntity> queryParams) {
        return userDao.countAuthorizationList(queryParams);
    }

    @Override
    public void bindAccid(UserEntity userentity) {
        userDao.bindAccid(userentity);
    }

    @Override
    public UserEntity getRemotePath(Integer resourceId) {
        List<UserEntity> list = userDao.getRemotePath(resourceId);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public UserEntity getCityName(String city) {
        List<UserEntity> list = userDao.getCityName(city);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public UserEntity getByCity(String city) {
        List<UserEntity> list = userDao.getByCity(city);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /**
     * 通过userId判断是否为主管
     *
     * @param userId
     * @return
     */
    @Override
    public Boolean isDirector(Integer userId) {
        return userDao.countSubordinate(userId) == 0 ? false : true;
    }

    @Override
    public UserEntity getUserEvaluation(String accId) {
        List<UserEntity> list = userDao.getUserEvaluation(accId);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void saveUnbindLog(UserEntity entity) {
        userDao.saveUnbindLog(entity);
    }
}
