/**
 * Description: 角色业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.RoleEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IRoleDao;
import com.house365.ws.service.interfaces.IRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 角色业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("roleService")
public class RoleServiceImpl<T extends RoleEntity> extends DefaultServiceImpl<T> implements IRoleService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IRoleDao<T> roleDao;

    @Override
    protected Dao<T> getDao() {
        return roleDao;
    }

    @Override
    public List<RoleEntity> getRolesByUserId(Integer userId) {
        return roleDao.getRolesByUserId(userId);
    }
}