/**
 * Description: 权限业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.PermissionEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IPermissionDao;
import com.house365.ws.service.interfaces.IPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 权限业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("permissionService")
public class PermissionServiceImpl<T extends PermissionEntity> extends DefaultServiceImpl<T> implements IPermissionService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IPermissionDao<T> permissionDao;

    @Override
    protected Dao<T> getDao() {
        return permissionDao;
    }

    @Override
    public List<PermissionEntity> getPermissionsByUserId(Integer userId) {
        return permissionDao.getPermissionsByUserId(userId);
    }

    @Override
    public List<PermissionEntity> getFunctionPermissionsByUserId(Integer userId) {
        return permissionDao.getFunctionPermissionsByUserId(userId);
    }

    @Override
    public List<PermissionEntity> queryAllByOrder() {
        return permissionDao.queryAllByOrder();
    }
}