/**
 * Description: Dictionary业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.DictionaryEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IDictionaryDao;
import com.house365.ws.service.interfaces.IDictionaryService;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Dictionary业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
@Service("dictionaryService")
public class DictionaryServiceImpl<T extends DictionaryEntity> extends DefaultServiceImpl<T> implements IDictionaryService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IDictionaryDao<T> dictionaryDao;

    @Override
    protected Dao<T> getDao() {
        return dictionaryDao;
    }

    @Override
    public T getByKey(String key) {
        DictionaryEntity entity = null;
        Map<String, Object> queryMap = new HashedMap();
        queryMap.put("EQ_dicKey", key);
        QueryParams queryParams = new QueryParams();
        queryParams.setSearchParams(queryMap);
        List<DictionaryEntity> dics = (List<DictionaryEntity>) dictionaryDao.queryAll(queryParams);
        if (dics != null && !dics.isEmpty()) {
            entity = dics.get(0);
        }
        return (T) entity;
    }

    @Override
    public T getByKeyAndCity(String key, String city) {
        DictionaryEntity entity = null;
        Map<String, Object> queryMap = new HashMap<>(10);
        queryMap.put("EQ_dicKey", key);
        queryMap.put("EQ_city", city);
        QueryParams queryParams = new QueryParams();
        queryParams.setSearchParams(queryMap);
        List<DictionaryEntity> dics = (List<DictionaryEntity>) dictionaryDao.queryAll(queryParams);
        if (dics != null && !dics.isEmpty()) {
            entity = dics.get(0);
        }
        return (T) entity;
    }

    @Override
    public List<DictionaryEntity> getListByKey(String key) {
        Map<String, Object> queryMap = new HashMap<>(10);
        queryMap.put("EQ_dicKey", key);
        QueryParams queryParams = new QueryParams();
        queryParams.setSearchParams(queryMap);
        List<DictionaryEntity> entities = (List<DictionaryEntity>) dictionaryDao.queryAll(queryParams);
        return entities;
    }

    @Override
    public void deleteByKey(String key) {
        dictionaryDao.deleteByKey(key);
    }
}
