/**
 * Description: 部门业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IDepartmentDao;
import com.house365.ws.service.interfaces.IDepartmentService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 部门业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("departmentService")
public class DepartmentServiceImpl<T extends DepartmentEntity> extends DefaultServiceImpl<T> implements IDepartmentService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IDepartmentDao<T> departmentDao;

    @Override
    protected Dao<T> getDao() {
        return departmentDao;
    }

    @Override
    public List<DepartmentEntity> findChildrenListByPath(List<DepartmentEntity> parents) {
        return departmentDao.findChildrenListByPath(parents);
    }

    @Override
    public String getCityByDepartmentId(Integer departmentId) {
        String city = "";
        DepartmentEntity departmentEntity = departmentDao.getById(departmentId);
        String[] departmentIds = departmentEntity.getUrlPath().split("/");
        if (departmentIds.length > 2) {
            DepartmentEntity departmentCity = departmentDao.getById(Integer.valueOf(departmentIds[2]));
            city = departmentCity.getDescripition();
        }
        return city;
    }

    @Override
    public DepartmentEntity getDepartmentIdByCity(String city) {
        DepartmentEntity departmentEntity = null;
        Map<String, Object> deptQueryMap = new HashMap<>();
        deptQueryMap.put("EQ_descripition", city);
        QueryParams queryParams = new QueryParams(deptQueryMap);
        List<DepartmentEntity> departmentEntities = (List<DepartmentEntity>) departmentDao.queryAll(queryParams);
        if(CollectionUtils.isNotEmpty(departmentEntities)){
            departmentEntity = departmentEntities.get(0);
        }
        return departmentEntity;
    }
}
