/**
 * Description: AppBrand业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-06-27 下午 13:16:36
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-06-27   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.beans.system.QueryParams;
import com.house365.commons.system.HttpClientUtil;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.service.interfaces.IAppQuartzService;
import com.house365.ws.service.interfaces.IUserProjectRecommendService;
import net.sf.json.JSONObject;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * AppBrand业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-06-27
 * @see
 * @since 1.0
 */
@Service("appQuartzService")
public class AppQuartzServiceImpl<T extends UserProjectRecommendEntity> extends DefaultServiceImpl<T> implements IAppQuartzService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppQuartzServiceImpl.class);
    private static final String TYPE_CONFIG = "HGS_CONFIG_";
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private RedisUtilsInterface redisUtil;

    @Autowired
    private IUserProjectRecommendService<UserProjectRecommendEntity> userProjectRecommendService;

    private Integer CACHE_TIME_SECOND = 1800;


    @Override
    public void setRecommendTask() {
        Map<String, Object> recommendMap = new HashMap<>(5);
        recommendMap.put("EQ_isDeleted", 0);
        QueryParams<Map<String, Object>> queryOpenParams = new QueryParams<>(recommendMap);
        List<UserProjectRecommendEntity> recommendEntities = userProjectRecommendService.queryAll(queryOpenParams);
        for (UserProjectRecommendEntity recommendEntity : recommendEntities) {
            JSONObject recommendObject = new JSONObject();

            try {
                String key = TYPE_CONFIG + "recommend_detail_" + recommendEntity.getProjectId() + "_" + recommendEntity.getChannel();
                List<NameValuePair> queryParams = new ArrayList<>();
                queryParams.add(new BasicNameValuePair("method", "getHouseDetailNew"));
                queryParams.add(new BasicNameValuePair("id", String.valueOf(recommendEntity.getProjectId())));
                queryParams.add(new BasicNameValuePair("p", String.valueOf(recommendEntity.getChannel())));
                queryParams.add(new BasicNameValuePair("city", recommendEntity.getCity()));
                queryParams.add(new BasicNameValuePair("source", "basic"));
                String url = "http://mapi.house365.com/taofang/v1.0/xf/";
                //设置超时时间，防止时间太长导致dubbo超时和请求堆积
                String jsonStr = HttpClientUtil.doGet(url, queryParams, 2000, null);

                LOGGER.debug("jsonStr=[{}]", jsonStr);

                JSONObject project = JSONObject.fromObject(jsonStr);

                recommendObject.put("h_prjid", project.get("prj_id"));
                recommendObject.put("h_id", project.get("h_id"));
                recommendObject.put("h_link", project.get("h_link"));
                recommendObject.put("h_name", project.get("h_name"));
                recommendObject.put("h_pinyin", project.get("h_pinyin"));//
                recommendObject.put("h_pic", project.get("h_pic"));
                recommendObject.put("h_price", project.get("h_price"));
                recommendObject.put("h_channel_str", project.get("h_channel"));
                recommendObject.put("h_channel", project.get("h_prj_channel"));
                recommendObject.put("h_project_address", project.get("h_project_address"));
                recommendObject.put("h_long", project.get("h_long"));
                recommendObject.put("h_lat", project.get("h_lat"));
                recommendObject.put("h_long_t", project.get("h_long_t"));
                recommendObject.put("h_lat_t", project.get("h_lat_t"));
                recommendObject.put("h_salestat_str", project.get("h_salestat_str"));
                recommendObject.put("h_dist", project.get("h_dist"));
                recommendObject.put("h_chara", project.get("h_chara"));
                recommendObject.put("h_saledate", project.get("h_saledate"));
                recommendObject.put("h_hotWords", project.get("h_hotWords"));
                recommendObject.put("h_yhinfo", project.get("h_yhinfo"));
                recommendObject.put("h_school", project.get("h_school"));
                recommendObject.put("h_metro", project.get("h_metro"));

//                recommendObject.put("h_recomm_houselist", project.get("h_recomm_houselist"));

                recommendObject.put("h_metro_tag", project.get("h_metro_tag"));//
                recommendObject.put("h_has_video", project.get("h_has_video"));
                recommendObject.put("h_has_qjkf", project.get("h_has_qjkf"));
                recommendObject.put("h_has_im_online", project.get("h_has_im_online"));//
                recommendObject.put("h_is_activity", project.get("h_is_activity"));//
//                recommendObject.put("shuang11", project.get("shuang11"));//
                recommendObject.put("jiaobiao", project.get("jiaobiao"));//
                recommendObject.put("h_has_kft", project.get("h_has_kft"));//
                recommendObject.put("h_rooms_str", project.get("h_rooms_str"));//
                recommendObject.put("is_zxdf", project.get("is_zxdf"));//
                recommendObject.put("is_vr", project.get("is_vr"));
                setCachedValue(key, recommendObject.toString(), CACHE_TIME_SECOND);
            } catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("直销人员楼盘推荐 楼盘接口无信息 楼盘id[{}] channel[{}]", recommendEntity.getProjectId(),
                        recommendEntity.getChannel(), e.getMessage());
            }
        }
    }


    private void setCachedValue(String key, Object value, long second) {
        redisUtil.addKeyObjectExpire(key, value, second);
    }

    @Override
    protected Dao<T> getDao() {
        return null;
    }
}
