/**
 * Description: 客户活动来源WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 08:58:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerSourceEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CustomerSourceListRequest;
import com.house365.ws.beans.request.CustomerSourceRequest;
import com.house365.ws.beans.response.CustomerSourceListResponse;
import com.house365.ws.beans.response.CustomerSourceResponse;
import com.house365.ws.dao.mapper.CustomerSourceMapper;
import com.house365.ws.interfaces.server.ICustomerSource;
import com.house365.ws.service.interfaces.ICustomerSourceService;
import com.house365.ws.system.ReturnResult;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 客户活动来源WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Service("customerSource")
public class CustomerSourceImpl implements ICustomerSource {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerSourceImpl.class);

    /**
     * 客户活动来源服务对象
     */
    @Autowired
    private ICustomerSourceService<CustomerSourceEntity> customerSourceService;
    @Autowired
    private CustomerSourceMapper customerSourceMapper;

    /**
     * 客户活动来源列表查询
     *
     * @param request 客户活动来源列表查询请求
     * @return 客户活动来源列表查询响应
     */
    @Override
    public CustomerSourceListResponse getCustomerSourceList(CustomerSourceListRequest request) {
        CustomerSourceListResponse response = new CustomerSourceListResponse();
        try {
            QueryParams<CustomerSourceEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CustomerSourceEntity> customerSources = customerSourceService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(customerSources);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存客户活动来源
     *
     * @param request 客户活动来源请求
     * @return 保存客户活动来源响应
     */
    @Override
    public CustomerSourceResponse addCustomerSource(CustomerSourceRequest request) {
        CustomerSourceResponse response = new CustomerSourceResponse();
        try {
            CustomerSourceEntity entity = request.getEntity();
            customerSourceService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除客户活动来源通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除客户活动来源响应
     */
    @Override
    public CustomerSourceResponse deleteCustomerSourceById(Integer id) {
        CustomerSourceResponse response = new CustomerSourceResponse();
        try {
            CustomerSourceEntity entity = customerSourceService.getById(id);
            entity.setStatus(0);
            customerSourceService.update(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改客户活动来源
     *
     * @param request 修改客户活动来源请求
     * @return 修改客户活动来源响应
     */
    @Override
    public CustomerSourceResponse updateCustomerSource(CustomerSourceRequest request) {
        CustomerSourceResponse response = new CustomerSourceResponse();
        try {
            customerSourceService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取客户活动来源
     *
     * @param id 唯一标识
     * @return 通过ID获取客户活动来源响应
     */
    @Override
    public CustomerSourceResponse getCustomerSourceById(Integer id) {
        CustomerSourceResponse response = new CustomerSourceResponse();
        try {
            CustomerSourceEntity entity = customerSourceService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public Integer updateSource(String cityCode, String actSource, String createSource, String crm) {
        return customerSourceService.updateSource(cityCode, actSource, createSource, crm);
    }

    @Override
    public List<CustomerSourceEntity> queryByConditions(Map<String, Object> map) {
        List<CustomerSourceEntity> list = customerSourceMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
