package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.mapper.CustomerStatusLogMapper;
import com.house365.ws.interfaces.server.IClearData;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/6/4.
 */
@Service("clearData")
public class ClearDataImpl implements IClearData {

    @Autowired
    private CustomerStatusLogMapper logMapper;

    @Override
    public List<CustomerStatusLogEntity> queryByCustomer() {
        List<CustomerStatusLogEntity> list = logMapper.queryByCustomer();
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<CustomerStatusLogEntity> queryByMap(Map<String, Object> map) {
        List<CustomerStatusLogEntity> list = logMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void clearData(List<CustomerStatusLogEntity> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CustomerStatusLogEntity c : list) {
                int id = c.getCustomerId();
                int projectId = c.getProjectId();
                Map<String, Object> map = new HashMap<>(5);
                map.put("customerId", id);
                map.put("projectId", projectId);
                List<CustomerStatusLogEntity> logList = logMapper.queryByCustomerId(map);
                if (CollectionUtils.isNotEmpty(logList)) {
                    int status = logList.get(0).getToStatusId();
                    int logId = logList.get(0).getId();

                    for (CustomerStatusLogEntity e : logList) {
                        if (e.getToStatusId() >= status && e.getId() != logId) {
                            Map<String, Object> updateMap = new HashMap<>(5);
                            updateMap.put("id", e.getId());
                            logMapper.updateIsDelete(updateMap);
                        }
                    }
                    for (int i = 1; i < status; i++) {
                        map.put("toStatusId", i);
                        List<CustomerStatusLogEntity> logNewList = logMapper.queryByCustomerId(map);
                        if (CollectionUtils.isNotEmpty(logNewList)) {
                            int newStatus = logNewList.get(0).getToStatusId();
                            int newLogId = logNewList.get(0).getId();
                            for (CustomerStatusLogEntity e : logNewList) {
                                if (e.getToStatusId() >= newStatus && e.getId() != newLogId) {
                                    Map<String, Object> updateMap = new HashMap<>(5);
                                    updateMap.put("id", e.getId());
                                    logMapper.updateIsDelete(updateMap);
                                }
                            }
                        }
                    }
                }
            }
        }

    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }


    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
