package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.BaseAttachmentRemoteUrl;
import com.house365.beans.system.QueryParams;
import com.house365.ws.beans.request.AttachmentRemoteUrlListRequest;
import com.house365.ws.beans.request.AttachmentRemoteUrlRequest;
import com.house365.ws.beans.response.AttachmentRemoteUrlListResponse;
import com.house365.ws.beans.response.AttachmentRemoteUrlResponse;
import com.house365.ws.interfaces.server.IAttachmentRemoteUrlInterface;
import com.house365.ws.service.interfaces.IAttachmentRemoteUrlService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("attachmentRemoteUrlInterface")
public class AttachmentRemoteUrlInterfaceImpl implements IAttachmentRemoteUrlInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentInterfaceImpl.class);

    @Autowired
    IAttachmentRemoteUrlService<BaseAttachmentRemoteUrl> attachmentRemoteUrlService;

    /**
     * 查询
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @SuppressWarnings("unchecked")
    @Override
    public AttachmentRemoteUrlListResponse getAttachmentRemoteUrls(AttachmentRemoteUrlListRequest request) {
        AttachmentRemoteUrlListResponse response = new AttachmentRemoteUrlListResponse();
        try {
            QueryParams<BaseAttachmentRemoteUrl> queryParams = new QueryParams<>(
                    request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<BaseAttachmentRemoteUrl> attachment = attachmentRemoteUrlService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(attachment);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 查询单个
     *
     * @param id
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentRemoteUrlResponse getAttachmentRemoteUrl(Integer id) {
        AttachmentRemoteUrlResponse response = new AttachmentRemoteUrlResponse();
        try {
            BaseAttachmentRemoteUrl attachmentRemoteUrl = attachmentRemoteUrlService.getById(id);
            response.setAttachmentRemoteUrl(attachmentRemoteUrl);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 添加
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentRemoteUrlResponse addAttachmentRemoteUrl(AttachmentRemoteUrlRequest request) {
        AttachmentRemoteUrlResponse response = new AttachmentRemoteUrlResponse();
        try {
            BaseAttachmentRemoteUrl attachmentRemoteUrl = request.getAttachmentRemoteUrl();
            Integer id = attachmentRemoteUrlService.save(attachmentRemoteUrl);
            attachmentRemoteUrl.setId(id);
            response.setAttachmentRemoteUrl(attachmentRemoteUrl);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentRemoteUrlResponse updateAttachmentRemoteUrl(AttachmentRemoteUrlRequest request) {
        AttachmentRemoteUrlResponse response = new AttachmentRemoteUrlResponse();
        try {
            BaseAttachmentRemoteUrl attachmentRemoteUrl = request.getAttachmentRemoteUrl();
            attachmentRemoteUrlService.update(attachmentRemoteUrl);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除
     *
     * @param id
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentRemoteUrlResponse deleteAttachmentRemoteUrl(Integer id) {
        AttachmentRemoteUrlResponse response = new AttachmentRemoteUrlResponse();
        try {
            attachmentRemoteUrlService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

}
