/**
 * Description: ProjectUser数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import java.util.HashMap;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IProjectUserDao;
import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.entity.UserEntity;

/**
 * ProjectUser数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Repository("projectUserDao")
public class ProjectUserDaoImpl extends DefaultDaoImpl<ProjectUserEntity> implements IProjectUserDao<ProjectUserEntity> {
    public List<UserEntity> queryUserByPrjId(Integer projectId) {
        return this.getReadTemplate().queryForList(getStatement(), projectId);
    }

    public List<UserEntity> getProjectUser(List<Integer> projectIds) {
        return this.getReadTemplate().queryForList(getStatement(), projectIds);
    }

    public List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode) {
        HashMap<String, Object> para = new HashMap<>();
        para.put("userId", userId);
        para.put("cityCode", cityCode);

        return this.getReadTemplate().queryForList(getStatement(), para);
    }

    @Override
    public List<ProjectEntity> getProjectByUserIdAndStatus(Integer userId, String cityCode, String showStatus) {
        HashMap<String, Object> para = new HashMap<>();
        para.put("userId", userId);
        para.put("cityCode", cityCode);
        para.put("showStatus", showStatus);

        return this.getReadTemplate().queryForList(getStatement(), para);
    }

}
