/**
 * Description: Project数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.ProjectDynamicEntity;
import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IProjectDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Project数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Repository("projectDao")
public class ProjectDaoImpl extends DefaultDaoImpl<ProjectEntity> implements IProjectDao<ProjectEntity> {

    @Override
    public List<ProjectEntity> queryCustomerProject(Integer customerId) {
        return this.query(getStatement(), customerId);
    }

    @Override
    public List<ProjectEntity> getDynamicById(ProjectDynamicEntity pde) {
        return this.query(getStatement(), pde);
    }

    @Override
    public List<ProjectDynamicEntity> getDynamicList(QueryParams<ProjectDynamicEntity> queryParams) {
        return getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public void updateHotline(String buildingId, String shorttel) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("buildingId", buildingId);
        map.put("shorttel", shorttel);
        this.update(getStatement(), map);
    }

    @Override
    public void saveDynamic(ProjectDynamicEntity projectdynamicentity) {
        this.save(getStatement(), projectdynamicentity);
    }

    @Override
    public void delDynamic(Integer dynamicId) {
        getReadTemplate().update(getStatement(), dynamicId);
    }

    @Override
    public void updateSaler() {
        this.update(getStatement(), null);
    }

    @Override
    public List<ProjectEntity> queryByConditions(Map<String, Object> map) {
        return this.query(getStatement(), map);
    }
}
