/**
 * Description: HouseInfo数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-18 下午 15:44:53
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.HouseInfoEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.beans.response.HouseInfoListResponse;
import com.house365.ws.dao.interfaces.IHouseInfoDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * HouseInfo数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
@Repository("houseInfoDao")
public class HouseInfoDaoImpl extends DefaultDaoImpl<HouseInfoEntity> implements IHouseInfoDao<HouseInfoEntity> {

    @Override
    public List<HouseInfoEntity> getHouseByHouseId(Integer houseId) {
        return getWriteTemplate().queryForList(getStatement(), houseId);
    }

    @Override
    public List<HouseInfoEntity> getHouseInfoListByActiveId(Integer activeId) {
        return getWriteTemplate().queryForList(getStatement(), activeId);
    }

}
