/**
 * Description: 客户状态变更纪录数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICustomerStatusLogDao;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 客户状态变更纪录数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Repository("customerStatusLogDao")
public class CustomerStatusLogDaoImpl extends DefaultDaoImpl<CustomerStatusLogEntity> implements ICustomerStatusLogDao<CustomerStatusLogEntity> {

    @Override
    public CustomerStatusLogEntity addCustomerStatusLog(CustomerStatusLogEntity customerStatusLogEntity) {
        Integer entityId = (Integer) getWriteTemplate().insert("save", customerStatusLogEntity);
        if (entityId != null && entityId > 0) {
            customerStatusLogEntity.setId(entityId);
        }
        return customerStatusLogEntity;
    }

    @Override
    public List<Map<String, Long>> getProjectTransform(Map<String, Object> map) {
        return this.getReadTemplate().queryForList(getStatement(), map);
    }

    @Override
    public List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map) {
        return this.getReadTemplate().queryForList(getStatement(), map);
    }
}
