package com.house365.ws.dao.impl;

import com.house365.beans.entity.BaseAttachment;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IAttachmentDao;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Component("attachmentDao")
public class AttachmentDaoImpl extends DefaultDaoImpl<BaseAttachment> implements IAttachmentDao<BaseAttachment> {

    /**
     * 通过resouceId查询
     */
    @SuppressWarnings({"unchecked", "deprecation"})
    @Override
    public List<BaseAttachment> getByResourceId(Integer resourceId) {
        return (List<BaseAttachment>) this.getReadTemplate().queryForList(getStatement(), resourceId);
    }

    @SuppressWarnings({"unchecked", "deprecation"})
    @Override
    public List<BaseAttachment> queryByResouceType(String channel){
        return (List<BaseAttachment>) this.getReadTemplate().queryForList(getStatement(), channel);
    }

    /**
     * 根据resourceId和resouceType查询
     */
    @SuppressWarnings({"deprecation", "unchecked"})
    @Override
    public List<BaseAttachment> queryByResourceIdAndResouceType(final String resourceId, final String channel) {
        return (List<BaseAttachment>) this.getReadTemplate().queryForList(getStatement(),
                new HashMap<String, String>() {
                    private static final long serialVersionUID = 1L;

                    {
                        put("resourceId", resourceId);
                        put("channel", channel);
                    }
                }

        );
    }

    /**
     * 获取数据库当前时间
     *
     * @return 数据库当前时间
     */
    @Override
    public Date getDbNow() {
        return (Date) this.getObject(getStatement(), null);
    }

}
