/**
 * Description: 统计信息WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-27 下午 15:54:06
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-27   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.StatisticListRequest;
import com.house365.ws.beans.request.StatisticRequest;
import com.house365.ws.beans.response.StatisticListResponse;
import com.house365.ws.beans.response.StatisticResponse;

import java.util.HashMap;
import java.util.Map;


/**
 * 统计信息WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-27
 * @see
 * @since 1.0
 */
public interface IStatistic extends IService{

    /**
     * 统计信息列表查询
     * 
     * @param request
     *            统计信息列表查询请求
     * @return 统计信息列表查询响应
     */
    StatisticListResponse getStatisticList(
        StatisticListRequest request
    );

    /**
     * 保存统计信息
     * 
     * @param request
     *            统计信息请求
     * @return 保存统计信息响应
     */
    StatisticResponse addStatistic(StatisticRequest request);

    /**
     * 删除统计信息通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除统计信息响应
     */
    StatisticResponse deleteStatisticById(Integer id);

    /**
     * 修改统计信息
     * 
     * @param request
     *            修改统计信息请求
     * @return 修改统计信息响应
     */
    StatisticResponse updateStatistic(
        StatisticRequest request
    );

    /**
     * 通过ID获取统计信息
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取统计信息响应
     */
    StatisticResponse getStatisticById(Integer id);

    House365RestResponse getDistinctReportName(String city);

    HashMap getIndexReport(String city);
}
