/**
 * Description: 角色WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.RoleListRequest;
import com.house365.ws.beans.request.RoleRequest;
import com.house365.ws.beans.response.RoleListResponse;
import com.house365.ws.beans.response.RoleResponse;


/**
 * 角色WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IRole extends IService{

    /**
     * 角色列表查询
     * 
     * @param request
     *            角色列表查询请求
     * @return 角色列表查询响应
     */
    RoleListResponse getRoleList(RoleListRequest request);

    /**
     * 保存角色
     * 
     * @param request
     *            角色请求
     * @return 保存角色响应
     */
    RoleResponse addRole(RoleRequest request);

    /**
     * 删除角色通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除角色响应
     */
    RoleResponse deleteRoleById(Integer id);

    /**
     * 修改角色
     * 
     * @param request
     *            修改角色请求
     * @return 修改角色响应
     */
    RoleResponse updateRole(RoleRequest request);

    /**
     * 通过ID获取角色
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取角色响应
     */
    RoleResponse getRoleById(Integer id);
}
