/**
 * Description: ProjectUserWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-18 上午 10:05:26
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import java.util.List;
import java.util.Map;

import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ProjectUserListRequest;
import com.house365.ws.beans.request.ProjectUserRequest;
import com.house365.ws.beans.response.ProjectUserListResponse;
import com.house365.ws.beans.response.ProjectUserResponse;


/**
 * ProjectUserWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface IProjectUser extends IService{

    /**
     * ProjectUser列表查询
     * 
     * @param request
     *            ProjectUser列表查询请求
     * @return ProjectUser列表查询响应
     */
    ProjectUserListResponse getProjectUserList(
            ProjectUserListRequest request);

    /**
     * 保存ProjectUser
     * 
     * @param request
     *            ProjectUser请求
     * @return 保存ProjectUser响应
     */
    ProjectUserResponse addProjectUser(ProjectUserRequest request);

    /**
     * 删除ProjectUser通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除ProjectUser响应
     */
    ProjectUserResponse deleteProjectUserById(Integer id);

    /**
     * 修改ProjectUser
     * 
     * @param request
     *            修改ProjectUser请求
     * @return 修改ProjectUser响应
     */
    ProjectUserResponse updateProjectUser(
            ProjectUserRequest request);

    /**
     * 通过ID获取ProjectUser
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取ProjectUser响应
     */
    ProjectUserResponse getProjectUserById(Integer id);
    
    //获取项目的
    List<UserEntity> queryUserByPrjId(Integer projectId);
    
}
