/**
 * Description: ProjectSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import java.util.List;

import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ProjectSourceStatisticsListRequest;
import com.house365.ws.beans.request.ProjectSourceStatisticsRequest;
import com.house365.ws.beans.response.ProjectSourceStatisticsListResponse;
import com.house365.ws.beans.response.ProjectSourceStatisticsResponse;


/**
 * ProjectSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
public interface IProjectSourceStatistics extends IService {

    /**
     * ProjectSourceStatistics列表查询
     *
     * @param request
     *            ProjectSourceStatistics列表查询请求
     * @return ProjectSourceStatistics列表查询响应
     */
    ProjectSourceStatisticsListResponse getProjectSourceStatisticsList(
        ProjectSourceStatisticsListRequest request
    );

    /**
     * 保存ProjectSourceStatistics
     *
     * @param request
     *            ProjectSourceStatistics请求
     * @return 保存ProjectSourceStatistics响应
     */
    ProjectSourceStatisticsResponse addProjectSourceStatistics(ProjectSourceStatisticsRequest request);

    /**
     * 删除ProjectSourceStatistics通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除ProjectSourceStatistics响应
     */
    ProjectSourceStatisticsResponse deleteProjectSourceStatisticsById(Integer id);

    /**
     * 修改ProjectSourceStatistics
     *
     * @param request
     *            修改ProjectSourceStatistics请求
     * @return 修改ProjectSourceStatistics响应
     */
    ProjectSourceStatisticsResponse updateProjectSourceStatistics(
        ProjectSourceStatisticsRequest request
    );

    /**
     * 通过ID获取ProjectSourceStatistics
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取ProjectSourceStatistics响应
     */
    ProjectSourceStatisticsResponse getProjectSourceStatisticsById(Integer id);

    List<ProjectSrouceRePo> getProjectSourceStatistics(ProjectSrouceParaPo para);

    ProjectSourceStatisticsListResponse statisticCustomer(
        ProjectSourceStatisticsListRequest request
    );
}
