/**
 * Description: ProjectWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ProjectListRequest;
import com.house365.ws.beans.request.ProjectRequest;
import com.house365.ws.beans.response.ProjectListResponse;
import com.house365.ws.beans.response.ProjectResponse;
import com.house365.ws.beans.util.HResult;

import java.util.List;
import java.util.Map;


/**
 * ProjectWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface IProject extends IService {

    List<ProjectEntity> getProjectListByUserId(Integer userId, String cityCode, String showStatus);

    /**
     * Project列表查询
     *
     * @param request Project列表查询请求
     * @return Project列表查询响应
     */
    ProjectListResponse getProjectList(ProjectListRequest request);

    ProjectResponse addProject(ProjectRequest request, int userId, String userName);

    ProjectResponse deleteProjectById(Integer id);

    ProjectResponse updateProject(ProjectRequest request, int userId, String userName);

    ProjectResponse getProjectById(Integer id);

    List<ProjectEntity> getProjectListByUserId(Integer userId, String cityCode);

    ProjectListResponse queryCustomerProject(Integer customerId);

    void updateHotline(String buildingId, String shorttel);

    void updateSaler();

    List<ProjectEntity> queryByConditions(Map<String, Object> map);

    List<ProjectEntity> queryByCondition(Map<String, Object> map);
}
