/**
 * Description: 营销活动WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.beans.vo.MarketingActivityVo;
import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestObject;
import com.house365.ws.beans.request.MarketingActivityListRequest;
import com.house365.ws.beans.request.MarketingActivityRequest;
import com.house365.ws.beans.response.MarketingActivityListResponse;
import com.house365.ws.beans.response.MarketingActivityResponse;

import java.util.Map;


/**
 * 营销活动WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IMarketingActivity extends IService {

    /**
     * 营销活动列表查询
     *
     * @param request 营销活动列表查询请求
     * @return 营销活动列表查询响应
     */
    MarketingActivityListResponse getMarketingActivityList(MarketingActivityListRequest request);

    /**
     * 保存营销活动
     *
     * @param request 营销活动请求
     * @return 保存营销活动响应
     */
    MarketingActivityResponse addMarketingActivity(MarketingActivityRequest request);

    MarketingActivityResponse addQueryCond(MarketingActivityRequest request);

    MarketingActivityListResponse queryAllPullCount(MarketingActivityListRequest request);

    /**
     * 删除营销活动通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除营销活动响应
     */
    MarketingActivityResponse deleteMarketingActivityById(Integer id);

    MarketingActivityEntity getQueryCondByActiveId(Integer id);

    /**
     * 修改营销活动
     *
     * @param request 修改营销活动请求
     * @return 修改营销活动响应
     */
    MarketingActivityResponse updateMarketingActivity(MarketingActivityRequest request);

    /**
     * 通过ID获取营销活动
     *
     * @param id 唯一标识
     * @return 通过ID获取营销活动响应
     */
    MarketingActivityResponse getMarketingActivityById(Integer id);

    void importCustomers(House365RestObject object, DepartmentEntity city);

    Integer queryCustomerCountByActive(Integer id);

    void putOvertimeWaitCallToOcean();
}
