/**
 * Description: 驻场日报WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-07-17 上午 10:14:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.vo.LocalReportFormVo;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.LocalReportListRequest;
import com.house365.ws.beans.request.LocalReportRequest;
import com.house365.ws.beans.response.LocalReportListResponse;
import com.house365.ws.beans.response.LocalReportResponse;
import com.house365.ws.system.House365SearchResponse;

import java.util.List;


/**
 * 驻场日报WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface ILocalReport extends IService{

    List<LocalReportFormVo> queryFormVO(String city);

    List<LocalReportFormVo> queryFormVORecord(String city, String reportDate, Integer projectId);

    /**
     * 驻场日报列表查询
     * 
     * @param request
     *            驻场日报列表查询请求
     * @return 驻场日报列表查询响应
     */
    LocalReportListResponse getLocalReportList(
        LocalReportListRequest request
    );

    LocalReportResponse saveReport(String data, String project, String reportDateStr, String city, String user) throws Exception;

    /**
     * 保存驻场日报
     * 
     * @param request
     *            驻场日报请求
     * @return 保存驻场日报响应
     */
    LocalReportResponse addLocalReport(LocalReportRequest request);

    /**
     * 删除驻场日报通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除驻场日报响应
     */
    LocalReportResponse deleteLocalReportById(Integer id);

    /**
     * 修改驻场日报
     * 
     * @param request
     *            修改驻场日报请求
     * @return 修改驻场日报响应
     */
    LocalReportResponse updateLocalReport(
        LocalReportRequest request
    );

    /**
     * 通过ID获取驻场日报
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取驻场日报响应
     */
    LocalReportResponse getLocalReportById(Integer id);

    House365SearchResponse statistic(LocalReportListRequest reportRequest);

    /**
     * 获取当月月报日历
     *
     * @param startTime 月报起始时间
     * @param endTime   月报结束时间
     * @param city
     * @return 已填写日报日期
     */
    List<ReportDailyPo> getDailies(String startTime, String endTime, String city);
}
