/**
 * Description: 项目日报-城市部门配置WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-08-09 下午 14:31:30
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-08-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CityDepConfigListRequest;
import com.house365.ws.beans.request.CityDepConfigRequest;
import com.house365.ws.beans.response.CityDepConfigListResponse;
import com.house365.ws.beans.response.CityDepConfigResponse;


/**
 * 项目日报-城市部门配置WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-08-09
 * @see
 * @since 1.0
 */
public interface ICityDepConfig extends IService {

    /**
     * 项目日报-城市部门配置列表查询
     *
     * @param request
     *            项目日报-城市部门配置列表查询请求
     * @return 项目日报- 城市部门配置列表查询响应
     */
    CityDepConfigListResponse getCityDepConfigList(CityDepConfigListRequest request);

    /**
     * 保存项目日报-城市部门配置
     *
     * @param request
     *            项目日报-城市部门配置请求
     * @return 保存项目日报-城市部门配置响应
     */
    CityDepConfigResponse addCityDepConfig(CityDepConfigRequest request);

    /**
     * 删除项目日报-城市部门配置通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除项目日报-城市部门配置响应
     */
    CityDepConfigResponse deleteCityDepConfigById(Integer id);

    /**
     * 修改项目日报-城市部门配置
     *
     * @param request
     *            修改项目日报-城市部门配置请求
     * @return 修改项目日报-城市部门配置响应
     */
    CityDepConfigResponse updateCityDepConfig(CityDepConfigRequest request);

    /**
     * 通过ID获取项目日报-城市部门配置
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取项目日报-城市部门配置响应
     */
    CityDepConfigResponse getCityDepConfigById(Integer id);
}
