<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/wechatpermission<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/wechatpermission">权限列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/wechatpermission/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/wechatpermission" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/wechatpermission/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/wechatpermission" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">编码:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.code"
                                               name="entity.code"
                                               value="${entity.code}"/>
                                        <font color="red"><form:errors path="permissionVo.entity.code"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.code}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}"/>
                                        <font color="red"><form:errors path="permissionVo.entity.name"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">父权限ID:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.parentId"
                                               name="entity.parentId"
                                               value="${entity.parentId}"/>
                                        <font color="red"><form:errors path="permissionVo.entity.parentId"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.parentId}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">排序:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.orderNum"
                                               name="entity.orderNum"
                                               value="${entity.orderNum}"/>
                                        <font color="red"><form:errors path="permissionVo.entity.orderNum"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.orderNum}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">对应资源:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.resource"
                                               name="entity.resource"
                                               value="${entity.resource}"/>
                                        <font color="red"><form:errors path="permissionVo.entity.resource"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.resource}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <input type="hidden" id="entity.special" name="entity.special" value="${entity.special}"/>
                        <%--<div class="span6 control-group">--%>
                        <%--<label class="control-label">特别权限</label>--%>
                        <%--<div class="controls">--%>
                        <%--<c:choose>--%>
                        <%--<c:when test="${action=='create'}">--%>
                        <%--<select class="required chosen" id="entity.special" name="entity.special"--%>
                        <%--data-placeholder="特别权限">--%>
                        <%--<option value="true">是</option>--%>
                        <%--<option value="false">否</option>--%>
                        <%--</select>--%>
                        <%--<font color="red"><form:errors path="userVo.entity.special"/></font>--%>
                        <%--</c:when>--%>
                        <%--<c:when test="${action=='edit'}">--%>
                        <%--<select class="required chosen" id="entity.special" name="entity.special"--%>
                        <%--data-placeholder="特别权限">--%>
                        <%--<option value="true"--%>
                        <%--<c:if test="${entity.special eq true}">selected="selected"</c:if>>是--%>
                        <%--</option>--%>
                        <%--<option value="false"--%>
                        <%--<c:if test="${entity.special eq false}">selected="selected"</c:if>>否--%>
                        <%--</option>--%>
                        <%--</select>--%>
                        <%--<font color="red"><form:errors path="userVo.entity.special"/></font>--%>
                        <%--</c:when>--%>
                        <%--<c:otherwise>--%>
                        <%--<span class="inline">--%>
                        <%--<c:if test="${null ne entity.special && '' ne entity.special}">--%>
                        <%--<c:out value="是"/>--%>
                        <%--</c:if>--%>
                        <%--<c:if test="${null eq entity.special || '' eq entity.special}">--%>
                        <%--<c:out value="否"/>&nbsp;--%>
                        <%--</c:if>--%>
                        <%--</span>--%>
                        <%--</c:otherwise>--%>
                        <%--</c:choose>--%>

                        <%--</div>--%>
                        <%--</div>--%>
                        <input type="hidden" id="entity.type" name="entity.type" value="${entity.type}"/>
                        <%--<div class="span6 control-group">--%>
                        <%--<label class="control-label">类型:</label>--%>
                        <%--<div class="controls">--%>
                        <%--<c:choose>--%>
                        <%--<c:when test="${action=='create' || action=='edit'}">--%>
                        <%--<select class="required chosen" id="entity.type" name="entity.type"--%>
                        <%--data-placeholder="类型">--%>
                        <%--<option value="1"--%>
                        <%--<c:if test="${entity.type eq '1'}">selected="selected"</c:if>>菜单--%>
                        <%--</option>--%>
                        <%--<option value="2"--%>
                        <%--<c:if test="${entity.type eq '2'}">selected="selected"</c:if>>页面--%>
                        <%--</option>--%>
                        <%--&lt;%&ndash;<option value="3"&ndash;%&gt;--%>
                        <%--&lt;%&ndash;<c:if test="${entity.type eq '3'}">selected="selected"</c:if>>操作&ndash;%&gt;--%>
                        <%--&lt;%&ndash;</option>&ndash;%&gt;--%>
                        <%--</select>--%>
                        <%--<font color="red"><form:errors path="permissionVo.entity.type"/></font>--%>
                        <%--</c:when>--%>
                        <%--<c:otherwise>--%>
                        <%--<span class="inline"><c:if test="${entity.type eq '1'}">菜单</c:if><c:if--%>
                        <%--test="${entity.type eq '1'}">页面</c:if><c:if--%>
                        <%--test="${entity.type eq '1'}">操作</c:if>&nbsp;</span>--%>
                        <%--</c:otherwise>--%>
                        <%--</c:choose>--%>

                        <%--</div>--%>
                        <%--</div>--%>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.createUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.createTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.updateUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.updateTime }'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>

                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                </div>
            </div>
        </div>
    </div>

</form>
</body>

</html>