<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>员工列表</title>
    <style type="text/css">
        * {
            margin: 0;
            padding: 0;
        }

        li {
            list-style: none;
        }

        .clearfix:after,
        .clearfix:before {
            content: '.';
            display: block;
            visibility: hidden;
            font-size: 0;
            line-height: 0;
            width: 0;
            height: 0;
        }

        .clearfix:after {
            clear: both;
        }

        .clearfix {
            zoom: 1;
        }

        .choosemask {
            position: fixed;
            left: 0;
            top: 0;
            background-color: rgba(0, 0, 0, 0.5);
            width: 100%;
            height: 100%;
        }

        .choosemask-wrap {
            width: 280px;
            height: 147px;
            background-color: #fff;
            border: 1px solid #000;
            left: 50%;
            margin-left: -140px;
            top: 200px;
            position: absolute;
        }

        .choosemask-top {
            text-align: right;
            font-size: 20px;
            height: 22px;
            line-height: 22px;
        }

        .choosemask-close {
            cursor: pointer;
            padding: 0 5px;
        }

        .choosemask-bottom {
            width: 217px;
            margin: 0 auto;
        }

        .choosemask-title {
            font-size: 15px;
            height: 18px;
            line-height: 18px;
            text-align: center;
            margin-top: 15px;
        }

        .choosemask-fbs, .choosemask-aj {
            width: 84px;
            height: 23px;
            line-height: 23px;
            text-align: center;
            background-color: #11a0ca;
            color: #fff;
            font-size: 12px;
            cursor: pointer;
            border-radius: 4px;
            -webkit-border-radius: 4px;
            -moz-border-radius: 4px;
        }

        .choosemask-fbs.on, .choosemask-aj.on {
            color: orange;
        }

        .choosemask-fbs {
            float: left;
        }

        .choosemask-aj {
            float: right;
        }

        .choosemask-twobtn {
            margin-top: 36px;
        }
    </style>
</head>
<body>

<!-- 面包屑 begin -->
<div class="page-container" style="top: 80px;">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/user/" method="get">
                <input type="hidden" name="search_EQ_deptId" value="${sessionTreeDept}"
                class="m-wrap small span2" placeholder="deptId">
                <%--<input type="text" name="search_EQ_id" value="${param['search_EQ_id']}"--%>
                <%--class="m-wrap small span2" placeholder="用户ID">--%>
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="用户名">
                <input type="text" name="search_LIKE_realName" value="${param['search_LIKE_realName']}"
                       class="m-wrap small span2" placeholder="姓名">
                <input type="text" name="search_LIKE_mobile" value="${param['search_LIKE_mobile']}"
                       class="m-wrap small span2" placeholder="手机">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/user/?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:0px 10px 0 0px;">
                    <a href="javascript:;" onclick="addWxUser()" class="btn blue pull-right" title="新增">同步集团企业微信</a>
                </div>
                <div class="buttons pull-right" style="margin:0px 10px 0 0px;">
                    <a href="javascript:;" onclick="sycToWechat()" class="btn blue pull-right" title="新增">同步到微信企业号</a>
                </div>
                <div class="buttons pull-right" style="margin:3px 20px 0 0px;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="100">id</th>
            <th width="100">用户名</th>
            <th width="100">姓名</th>
            <th width="100">手机号</th>
            <th width="100">部门名称</th>
            <th width="100">职位</th>
            <th width="100">评分</th>
            <th width="100">评价</th>
            <th width="100">状态</th>
            <th width="100">创建时间</th>
            <th width="100">云信id</th>
            <th width="100">身份</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${users}" var="user">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${user.entity.id}"
                           data-hascustomers=${user.hasCustomers} onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/user/${user.entity.id}">
                        <c:if test="${null ne user.entity.id && '' ne user.entity.id}">
                            <c:out value="${user.entity.id}"/>
                        </c:if>
                        <c:if test="${null eq user.entity.id || '' eq user.entity.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne user.entity.name && '' ne user.entity.name}">
                        <c:out value="${user.entity.name}"/>
                    </c:if>
                    <c:if test="${null eq user.entity.name || '' eq user.entity.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne user.entity.realName && '' ne user.entity.realName}">
                        <c:out value="${user.entity.realName}"/>
                    </c:if>
                    <c:if test="${null eq user.entity.realName || '' eq user.entity.realName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne user.entity.mobile && '' ne user.entity.mobile}">
                        <c:out value="${user.entity.mobile}"/>
                    </c:if>
                    <c:if test="${null eq user.entity.mobile || '' eq user.entity.mobile}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne user.entity.deptName && '' ne user.entity.deptName}">
                        <c:out value="${user.entity.deptName}"/>
                    </c:if>
                    <c:if test="${null eq user.entity.deptName || '' eq user.entity.deptName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne user.entity.position && '' ne user.entity.position}">
                        <c:out value="${user.entity.position}"/>
                    </c:if>
                    <c:if test="${null eq user.entity.position || '' eq user.entity.position}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                        ${user.entity.score}
                </td>
                <td nowrap="nowrap">
                        ${user.entity.evaluateCount}
                </td>
                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${!user.entity.enabled}">
                            <span>冻结</span>
                        </c:when>
                        <c:when test="${user.entity.enabled}">
                            <span>可用</span>
                        </c:when>
                    </c:choose>
                </td>
                <td nowrap="nowrap">
                    <f:formatDate value='${user.entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </td>
                <td nowrap="nowrap">${user.entity.accId}</td>
                <td nowrap="nowrap">
                    <c:if test="${user.entity.identityType eq '1'}"> <c:out value="安家顾问"/></c:if>
                    <c:if test="${user.entity.identityType eq '3'}"> <c:out value="新房房博士"/></c:if>
                    <c:if test="${user.entity.identityType eq '6'}"> <c:out value="二手房房博士"/></c:if>
                    <c:if test="${user.entity.identityType eq '10'}"> <c:out value="租房房博士"/></c:if>
                    <c:if test="${user.entity.identityType eq '7'}"> <c:out value="客服"/></c:if>
                    <c:if test="${user.entity.identityType eq '20'}"> <c:out value="平台人员"/></c:if>
                    <c:if test="${user.entity.identityType eq '13'}"> <c:out value="房博士测试"/></c:if>
                    <c:if test="${user.entity.identityType eq '14'}"> <c:out value="其他房博士"/></c:if>
                    <c:if test="${null eq user.entity.identityType || '' eq user.entity.identityType}">
                        <c:out value=""/>
                    </c:if>
                </td>
                    <%-- <shiro:hasPermission name="USER_EDIT">  --%>
                <td nowrap="nowrap">
                        <%--<i class="icon-edit pointer icon-large" title="编辑"--%>
                        <%--onclick="window.location='${ctx}/user/${user.entity.id}?action=edit'"></i>--%>
                    <i class="icon-edit pointer icon-large" title="编辑"
                       onclick="goEdit(${user.entity.id})"></i>
                    &nbsp;&nbsp;
                    <i title="删除"
                       class="icon-minus pointer icon-large"
                       onclick="deleteById('${user.entity.id}', ${user.hasCustomers},${user.hasCustomersInPlatform})"> </i>
                    &nbsp;&nbsp;
                    <c:if test="${user.entity.enabled}">
                    <i title="锁定"
                       class="icon-unlock pointer icon-large"
                       onclick="lock(${user.entity.id})"> </i>
                    </c:if>
                    <c:if test="${not user.entity.enabled}">
                    <i title="解锁"
                       class="icon-lock pointer icon-large"
                       onclick="unlock(${user.entity.id})"> </i>
                    </c:if>
                    &nbsp;&nbsp;

                    <i class="icon-share-alt pointer icon-large" title="转移部门"
                       onclick="transferDept(${user.entity.id})"></i>&nbsp;&nbsp;
                        <%-- </td></shiro:hasPermission> --%>
                    <c:if test="${showIm == 1}">
                    <i class="icon-film pointer icon-large" title="IM"
                       onclick="identityIM(${user.entity.id}, ${user.entity.mobile})"></i>
                    </c:if>
                    &nbsp;&nbsp;
                    <i onclick="openAdd(${user.entity.id})" class="icon-plus pointer icon-large" title="新增"></i>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
    <input type="hidden" id="uid" value=""/>
    <input type="hidden" id="mobile" value=""/>
</div>

<div id="choosemask" class="choosemask" style="display: none">
    <div class="choosemask-wrap" style="width: 500px;height: 200px;">
        <div class="choosemask-top">
            <span id="choosemask_2" class="choosemask-close" onclick="hiddenChoosemask()" style="">×</span>
        </div>
        <div class="choosemask-bottom" style="width: 400px;">
            <div class="choosemask-title">请选择身份：</div>

            <ul class="choosemask-twobtn clearfix" id="fbs">
                <li class="choosemask-fbs" onclick="saveIM(3)">新房房博士</li>
                <li class="choosemask-fbs" onclick="saveIM(6)" style="margin-left: 10px;">二手房房博士</li>
                <li class="choosemask-fbs" onclick="saveIM(10)" style="margin-left: 10px;">租房房博士</li>
                <li class="choosemask-fbs" onclick="saveIM(14)" style="margin-left: 10px;">其他房博士</li>
            </ul>
            <ul class="choosemask-twobtn clearfix">
                <li class="choosemask-fbs" onclick="saveIM(7)" id="kefu">客服</li>
                <li class="choosemask-fbs" onclick="saveIM(1)" style="margin-left: 10px;">安家顾问</li>
                <li class="choosemask-fbs" onclick="saveIM(20)" style="margin-left: 10px;">平台人员</li>
            </ul>
        </div>
    </div>
</div>
<script language="javascript" type="text/javascript" src="${ctx}/resources/customize/js/layer.js"></script>

<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function identityIM(uid, mobile) {
        $.ajax({
            url: '${ctx}/user/judgeAdmin',
            type: 'GET',
            contentType: 'application/json',
            dataType: 'json',
            cache: false,
            success: function (result) {
                debugger;
                if (result.status != 0) {
                    $("#kefu").css("display", "none");
                    $("#fbs").css("display", "none");
                }
                var choosemask = document.getElementById("choosemask");
                choosemask.style.display = "block";
                $("#uid").val(uid);
                $("#mobile").val(mobile);
            }
        });

    }

    function saveIM(identityType) {
        var userId = $("#uid").val();
        var mobile = $("#mobile").val();
        $.ajax({
            url: '${ctx}/user/saveIM',
            data: {"userId": userId, "mobile": mobile, "identityType": identityType},
            type: "GET",
            success: function () {
                window.location.reload();
            }
        });
    }


    function hiddenChoosemask() {
        var obj = document.getElementById("choosemask");
        obj.style.display = "none";
    }

    function lock(obj) {
        debugger;
        if (obj == 257) {
            alert("appstore账户，请勿操作");
            return;
        }
        $.ajax({
            url: '${ctx}/user/lock/' + obj,
            type: "GET",
            success: function () {
                window.location.reload();
            }
        });
    }

    function unlock(obj) {
        $.ajax({
            url: '${ctx}/user/unlock/' + obj,
            type: "GET",
            success: function () {
                window.location.reload();
            }
        });
    }

    function goEdit(id) {
        debugger;
        if (id == 257) {
            alert("appstore账户，请勿操作");
            return;
        }
        var url = "/house365-hgs-web/user/" + id + "?action=edit";
        window.location = url;
//        window.location.href = url;
        <%--window.location='${ctx}/user/ + "" id + "" + ?action=edit';--%>
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId, hasCustomers,hasCustomersInPlatform) {
        var localHasCustomers = false;
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                    if ($("input[name='memberCheck']")[i].dataset.hascustomers == "true") {
                        localHasCustomers = true;
                    }
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除员工", "请至少选择一条员工!", function () {
            });
        } else {
            if (hasCustomers || localHasCustomers) {
                House365Util.createModal("删除员工", "员工名下还有客户，请转移交接给其他置业顾问后再删除。", function () {
                });
            }else if(hasCustomersInPlatform){
                House365Util.createModal("删除员工", "员工名下还有客户，请转移交接给其他平台人员后再删除。", function () {
                });
            } else {
                //获取删除用户的绑定楼盘信息
                $.ajax({
                    url: '${ctx}/user/bindPeople/' + selectedId,
                    type: "GET",
                    success: function (result) {
                        console.info(result.data)
                        if (result.status == 0) {
                            if(result.data!=null && result.data.length>0){
                                //员工有绑定的楼盘，不能删除
                                alert("请在团立方后台解绑该顾问");
                                return;
                            }else {
                                House365Util.createModal("删除员工", "删除后将无法恢复员工账号，请确认是否继续？", function () {
                                    debugger;
                                    if (selectedId.includes("257") == true) {
                                        alert("appstore账户，请勿操作");
                                        return;
                                    }
                                    $.ajax({
                                        url: '${ctx}/user/' + selectedId,
                                        type: "DELETE",
                                        success: function () {
                                            $("input[name='memberCheck']").removeAttr("checked");
                                            window.location.reload();
                                        }
                                    });
                                });
                            }
                        }else{
                            alert(result.errorMessage);
                        }
                    }
                });


                <%--House365Util.createModal("删除员工", "删除后将无法恢复员工账号，请确认是否继续？", function () {--%>
                <%--    debugger;--%>
                <%--    if (selectedId.includes("257") == true) {--%>
                <%--        alert("appstore账户，请勿操作");--%>
                <%--        return;--%>
                <%--    }--%>
                <%--    $.ajax({--%>
                <%--        url: '${ctx}/user/' + selectedId,--%>
                <%--        type: "DELETE",--%>
                <%--        success: function () {--%>
                <%--            $("input[name='memberCheck']").removeAttr("checked");--%>
                <%--            window.location.reload();--%>
                <%--        }--%>
                <%--    });--%>
                <%--});--%>

            }
        }

    };

    var addWxUser = function () {
        $.ajax({
            url: '${ctx}/user/saveWxUser',
            type: 'POST',
            contentType: 'application/json',
            data: '',
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("同步微信用户成功！");
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });

    };

    function sycToWechat() {
        var selectedId = "";
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                selectedId += document.getElementsByName('memberCheck')[i].value + ",";
            }
        }

        var str = "";
        if (selectedId != "") {
            str = selectedId.split(",");

            if (str[str.length - 1] == "") {
                selectedId = selectedId.substring(0, selectedId.length - 1);
            }
        }

        if (selectedId == "") {
            House365Util.createModal("同步员工", "请至少选择一条员工!", function () {
            });
        } else {
            House365Util.createModal("确认", "是否继续？", function () {
                $.ajax({
                    url: '${ctx}/user/syncToWechat/' + selectedId,
                    type: "GET",
                    success: function (re) {
                        if ("success" == re) {
                            layer.open({
                                content: "操作成功",
                                time: 2
                            });
                        } else if ("fail" == re) {
                            layer.open({
                                content: "操作失败",
                                time: 2
                            });
                        }
                    }
                });
            });
        }

    }

    function transferDept(obj) {
        House365Util.createRemoteModal("请选择部门", "${ctx}/department/transferDept", null, function () {
            var treeObj = $.fn.zTree.getZTreeObj("treeSelect1");
            var nodes = treeObj.getCheckedNodes(true);
            if (nodes[0] == undefined || nodes[0] == null) {
                window.location.reload();
                return true;
            }
            $.ajax({
                url: '${ctx}/department/transferDept/' + nodes[0].id + '/' + obj,
                data: {},
                type: "GET",
                success: function () {
                    window.location.reload();
                }
            });
            return true;
        });
    }

    var openAdd = function (id) {
        $("#userId").val(id);
        $("#bindModal").modal('show');
    };

    $(document).ready(function () {
        $("#searchName").select2({
            placeholder: "请选择微信用户",
            // 输入几个字符开始联想
            minimumInputLength: 1,
            // 最大返回记录数
            minimumResultsForSearch: 10,
            maximumSelectionLength: 1,
            minimumSelectionLength: 1,
            containerCssClass: "chosen, chosen-with-diselect",
            query: function (query) {
                $.ajax({
                    timeout: 1000,
                    url: "${ctx}/user/getByName",
                    data: {
                        userName: query.term
                    },
                    type: "GET",
                    dataType: "json",
                    success: function (data, status) {
                        var pageData = {
                            results: []
                        };
                        $.each(data.data, function (i, item) {
                            pageData.results.push({
                                id: item.wxId + ',' + item.userName,
                                text: item.userName + ',' + item.mobile
                            });
                        });
                        query.callback(pageData);
                    },
                    error: function () {
                        var pageData = {
                            results: []
                        };
                        query.callback(pageData);
                    }
                });
            }
        });
        $("#searchName").change(function () {
            var $this = $(this);
            var chooseName = $this.val();
            if (chooseName) {
                var tag = chooseName.split(",");
                var wxId = tag[0];
                $("#wxId").val(wxId);
            }
        });
    });

    var bindRelation = function () {
        var userId = $("#userId").val();
        var wxId = $("#wxId").val();
        if (typeof(wxId) == "undefined" || wxId == '' || wxId == null) {
            alert("请填写微信用户");
            return;
        }
        var data = {userId: userId, wxId: wxId};
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/user/saveRelation',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("绑定成功！");
                    $("#bindModal").modal('hide');
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });

    };

    var backAdd = function () {
        $("#bindModal").modal('hide');
    };

</script>

<div class="modal fade" id="bindModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h5 class="modal-title" id="myModalLabel">绑定微信用户</h5>
            </div>
            <input type="hidden" id="userId" class="m-wrap small"/>
            <input type="hidden" id="wxId" class="m-wrap small"/>
            <div style="margin-top: 10px;" id="tag">
                <div style="float: left;width: 80px">
                    <span class="control-label">微信用户:</span>
                </div>
                <input id="searchName" name="searchName" style="height: 20px;width: 200px;">
            </div>
            <div id="btnGive" class="modal-footer" style="margin-top: 20px;">
                <button type="button" class="btn btn-primary" onclick="bindRelation()">确认</button>
                <button type="button" class="btn btn-primary" onclick="backAdd()">取消</button>
            </div>
        </div>
    </div>
</div>
</body>
</html>
