<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>状态来源分析</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm"
                  action="${ctx}/statistic/statusSourceStatistic" method="get">
                <select name="status" id="status" data-placeholder="客户状态(默认全部)">
                    <option value=""></option>
                    <option value="0" <c:if test="${'0' eq param['status']}">selected="selected"</c:if>>未约看</option>
                    <option value="1" <c:if test="${'1' eq param['status']}">selected="selected"</c:if>>约看</option>
                    <option value="2" <c:if test="${'2' eq param['status']}">selected="selected"</c:if>>到访</option>
                    <option value="3" <c:if test="${'3' eq param['status']}">selected="selected"</c:if>>认筹</option>
                    <option value="4" <c:if test="${'4' eq param['status']}">selected="selected"</c:if>>认购</option>
                    <option value="5" <c:if test="${'5' eq param['status']}">selected="selected"</c:if>>签约</option>
                    <option value="6" <c:if test="${'6' eq param['status']}">selected="selected"</c:if>>退房</option>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                    <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图</option>
                    <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图</option>
                    <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图</option>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input type="text" name="startTime" id="startTime"
                       value="${startDate}"
                       class="m-wrap small mydate span2 " placeholder="起始时间">到
                <input type="text" name="endTime" id="endTime"
                       value="${endDate}"
                       class="m-wrap small mydate span2 " placeholder="截止时间">
                &nbsp;&nbsp;<a class="btn " onclick="btnSubmit();">状态来源分析</a>
                &nbsp;&nbsp;<a class="btn "
                               onclick="$('#filterForm').attr('action','${ctx}/statistic/statusSourceExportExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/statistic/statusSourceStatistic');">Excel下载</a>
                <input type="hidden" id="statisticType" name="statisticType" value="${statisticType}"/>
                <input type="hidden" id="displayTab" name="displayTab" value="${displayTab}"/>
            </form>
        </div>


        <ul class="nav nav-tabs" role="tablist">
            <li id="reportLi" role="presentation" class="active"><a href="#" onclick="dispayFun(1)">条形图展示</a></li>
            <li id="tableLi" role="presentation"><a href="#" onclick="dispayFun(2)">表格详情</a></li>
        </ul>

        <div class="span12" id="report" style="height:${divLength};">
            <!-- <div hidden="hidden" id="emptyMsg">
                 <span>请选择查询条件</span>
             </div> -->
            <!--  <div id="emptyMsg" class="alert alert-success span2" role="alert">请选择查询条件</div> -->
        </div>
        <div class="span11" id="table" style="display:none;">
            <table class="table table-bordered table-advance table-hover">
                <tr class="info">
                    <td width="100" style="text-align:center">城市</td>
                    <td width="100" style="text-align:center">客户状态</td>
                    <td width="100" style="text-align:center">日期</td>
                    <td width="100" style="text-align:center">来源</td>
                    <td width="100" style="text-align:center">客户数量</td>
                    <td width="100" style="text-align:center">环比</td>
                </tr>
                <c:forEach items="${tableData}" var="item">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;"><c:out
                                value="${item.cityname}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center">
                            <c:if test="${not empty item.customerStatus}">
                                <c:choose>
                                    <c:when test="${item.customerStatus eq '0'}">
                                        <span class="inline">未约看</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '1'}">
                                        <span class="inline">约看</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '2'}">
                                        <span class="inline">到访</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '3'}">
                                        <span class="inline">认筹</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '4'}">
                                        <span class="inline">认购</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '5'}">
                                        <span class="inline">签约</span>
                                    </c:when>
                                    <c:when test="${item.customerStatus eq '6'}">
                                        <span class="inline">退房</span>
                                    </c:when>
                                </c:choose>
                            </c:if>
                            <c:if test="${empty item.customerStatus}">
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center">
                                ${item.createTime}
                        </td>
                        <td nowrap="nowrap" style="text-align:center">
                            <c:out value="${item.sourcename}"></c:out>
                        </td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.customerNum}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.huanbi}"></c:out></td>
                    </tr>
                </c:forEach>
            </table>
            <div class="row${fluid}">
                <house365:pagination page="${page}"/>
            </div>
        </div>
    </div>

</div>

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">
    $(document).ready(function () {

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d-1}',
                        el: 'endTime'
                    })
                }
            });
        });

        <c:if test="${'1' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>

        <c:if test="${'2' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>

        <c:if test="${'3' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}'});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}'});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}'});
                });
            }
            setTime();
        });

        drawReport();
        dispayFun("${displayTab}");

        setTime();
    });

    function drawReport() {
        var myChart = echarts.init(document.getElementById('report'));

        var option = {
            title: {
                text: '状态来源分析'
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            legend: {
                data: [${report_data}]
            }, grid: { // 控制图的大小，调整下面这些值就可以，
                //x: 40,
                //x2: 100,
                //y2: 350,// y2可以控制 X轴跟Zoom控件之间的间隔，避免以为倾斜后造成 label重叠到zoom上
                left: '20%'
            },
            xAxis: {
                type: 'value'
            },
            yAxis: {
                type: 'category',
                axisLabel: {interval: 0},
                data: [${yAxis_data}]
            },
            series: ${viewList}
        };
        myChart.setOption(option);

        window.onresize = function () {
            myChart.resize();
        }
    }


    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }

    function btnSubmit() {
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
            $("#displayTab").val("1");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
            $("#displayTab").val("2");
        }
    }
</script>
</body>
</html>
