<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>抢客客户信息列表</title>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">抢客客户信息列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/rushcustomer?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>抢客客户信息列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active">共${summary['totalCount']}条数据，今日新增${summary['todayCount']}条</li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/rushcustomer" method="get">
                <input type="hidden" name="type" value="${type}"/>
                <input type="text" name="phone" value="${param['phone']}"
                       class="m-wrap small" placeholder="姓名或手机号">
                <select style="width: 6rem" name="timeType" id="timeType"
                        onchange="changeTimeFilter(this.value)">
                    <option value="1"
                            <c:if test="${'1' eq param['timeType']}">selected="selected"</c:if>>
                        全部
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['timeType']}">selected="selected"</c:if>>
                        最近1天
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['timeType']}">selected="selected"</c:if>>
                        最近7天
                    </option>
                    <option value="0"
                            <c:if test="${'0' eq param['timeType']}">selected="selected"</c:if>>
                        自定义
                    </option>
                </select>
                <div class="timeSelector">
                    <div class="timeSelector__type1"
                         <c:if test="${'0' eq param['timeType']}">style="display: none;"</c:if>>${param['createTimeStart']}
                        至 ${param['createTimeEnd']}</div>
                    <div class="timeSelector__type2"
                         <c:if test="${'0' ne param['timeType']}">style="display: none;"</c:if>>
                        <input style="width: 7rem" type="text" name="createTimeStart"
                               id="createTimeStart" value="${param['createTimeStart']}"
                               class="m-wrap small span2"
                               placeholder="创建时间-起始">至
                        <input style="width: 7rem" type="text" name="createTimeEnd"
                               id="createTimeEnd" value="${param['createTimeEnd']}"
                               class="m-wrap small span2"
                               placeholder="创建时间-截止">
                        <div class="btn" style="margin-left: 10px;" onclick="$('#filterForm').submit();">确定</div>
                    </div>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation"<c:if test="${type eq '0'}"> class="active"</c:if>><a href="${ctx}/rushcustomer?type=0">待抢(${rushCustomerCounts.type0})</a>
        </li>
        <li role="presentation"<c:if test="${type eq '1'}"> class="active"</c:if>><a href="${ctx}/rushcustomer?type=1">已抢(${rushCustomerCounts.type1})</a>
        </li>
        <li role="presentation"<c:if test="${type eq '2'}"> class="active"</c:if>><a href="${ctx}/rushcustomer?type=2">不抢(${rushCustomerCounts.type2})</a>
        </li>
    </ul>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">姓名</th>
            <th width="100">电话</th>
            <th width="100">报名来源</th>
            <th width="100">项目</th>
            <th width="100">添加时间</th>
            <c:if test="${type eq '0' || type eq '1'}">
                <th width="100">置业顾问</th>
            </c:if>
            <c:if test="${type eq '0'||type eq '1'}">
                <th width="100">抢客时间</th>
            </c:if>
            <c:if test="${type ne '1'}">
                <th width="150">操作</th>
            </c:if>
        </tr>
        </thead>
        <c:forEach items="${rushCustomers}" var="rushCustomer">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${rushCustomer.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.id && '' ne rushCustomer.id}">
                        <c:out value="${rushCustomer.id}"/>
                    </c:if>
                    <c:if test="${null eq rushCustomer.id || '' eq rushCustomer.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.name && '' ne rushCustomer.name}">
                        ${fn:substring(rushCustomer.name, 0, 3)}
                    </c:if>
                    <c:if test="${null eq rushCustomer.name || '' eq rushCustomer.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.phone && '' ne rushCustomer.phone}">
                        <c:out value="${rushCustomer.phone}"/>
                    </c:if>
                    <c:if test="${null eq rushCustomer.phone || '' eq rushCustomer.phone}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.actSource && '' ne rushCustomer.actSource}">
                        ${fn:substring(rushCustomer.actSource, 0, 35)}
                    </c:if>
                    <c:if test="${null eq rushCustomer.actSource || '' eq rushCustomer.actSource}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.projectName && '' ne rushCustomer.projectName}">
                        ${fn:substring(rushCustomer.projectName, 0, 35)}
                    </c:if>
                    <c:if test="${null eq rushCustomer.projectName || '' eq rushCustomer.projectName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomer.createTime && '' ne rushCustomer.createTime}">
                        <f:formatDate value='${rushCustomer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq rushCustomer.createTime || '' eq rushCustomer.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <c:if test="${type eq '1'}">
                    <td nowrap="nowrap">
                        <c:if test="${null ne rushCustomer.managerName && '' ne rushCustomer.managerName}">
                            ${rushCustomer.managerName}(${rushCustomer.managerCount})
                        </c:if>
                        <c:if test="${null eq rushCustomer.managerName || '' eq rushCustomer.managerName}">
                            &nbsp;
                        </c:if>
                    </td>
                </c:if>
                <c:if test="${type eq '0'}">
                    <td nowrap="nowrap">
                        待抢
                    </td>
                </c:if>
                <c:if test="${type eq '0'}">
                    <td nowrap="nowrap">
                        &nbsp;
                    </td>
                </c:if>
                <c:if test="${type eq '1'}">
                    <td nowrap="nowrap">
                        <c:if test="${null ne rushCustomer.updateTime && '' ne rushCustomer.updateTime}">
                            <f:formatDate value='${rushCustomer.updateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                        </c:if>
                        <c:if test="${null eq rushCustomer.updateTime || '' eq rushCustomer.updateTime}">
                            &nbsp;
                        </c:if>
                    </td>
                </c:if>
                <c:if test="${type ne '1'}">
                    <td nowrap="nowrap">
                        <span class="pointer"
                              onclick="assignManagerSingle(${rushCustomer.id})">派工</span>
                        &nbsp;&nbsp; <span
                            title="删除"
                            class="pointer"
                            onclick="deleteById('${rushCustomer.id}')">删除</span>
                    </td>
                </c:if>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
</script>
<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    $(function () {
        var startTime = $("#createTimeStart")
        var endTime = $("#createTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true,
                startDate: "%y-{%M-1}-%d",
                minDate: startTime.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        startTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true,
                startDate: "%y-{%M-1}-%d",
                maxDate: endTime.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    //                    $("#createTimeEnd").click();
                    WdatePicker({
                        doubleCalendar: true,
                        startDate: "%y-{%M-1}-%d",
                        minDate: startTime.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'createTimeEnd'
                    })
                }
            });
        });
        if ($("#timeType").val() == "1") {
            $(".timeSelector__type1").text("");
        } else if ($("#timeType").val() == "2") {
            var timeStart, timeEnd;
            var myDate = new Date();
            timeEnd = myDate.pattern("yyyy-MM-dd");
            myDate.setDate(myDate.getDate() - 1);
            timeStart = myDate.pattern("yyyy-MM-dd");
            $("#createTimeEnd").val(timeEnd);
            $("#createTimeStart").val(timeStart);

            $(".timeSelector__type1").text(timeStart + " 至 " + timeEnd);
        } else if ($("#timeType").val() == "3") {
            var timeStart, timeEnd;
            var myDate = new Date();
            timeEnd = myDate.pattern("yyyy-MM-dd");
            myDate.setDate(myDate.getDate() - 7);
            timeStart = myDate.pattern("yyyy-MM-dd");
            $("#createTimeEnd").val(timeEnd);
            $("#createTimeStart").val(timeStart);

            $(".timeSelector__type1").text(timeStart + " 至 " + timeEnd);
        } else {
            $(".timeSelector__type1").text($("#createTimeStart").val() + " 至 " + $("#createTimeEnd").val());
        }
    });

    function changeTimeFilter(_value) {
        var timeStart, timeEnd;
        var myDate = new Date();

        switch (_value) {
            case"0":
                timeEnd = $("#createTimeEnd").val() || myDate.pattern("yyyy-MM-dd");
                timeStart = $("#createTimeStart").val() || myDate.pattern("yyyy-MM-dd");
                $(".timeSelector__type1").hide();
                $(".timeSelector__type2").show();
                break;
            case"2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                break;
            case"3":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7);
                timeStart = myDate.pattern("yyyy-MM-dd");
                break;
            default:
                break;
        }
        $("#createTimeEnd").val(timeEnd);
        $("#createTimeStart").val(timeStart);
        if (_value != "0") {
            $("#filterForm").submit();
        }
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除客户", "请至少选择一条客户!", function () {
            });
        }
        else {
            House365Util.createModal("删除客户", "确定要删除该客户？", function () {
                $.ajax({
                    url: '${ctx}/rushcustomer/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    function assignManagerSingle(obj) {

        House365Util.createRemoteModal("派工", "${ctx}/rushcustomer/assignManager?customerCount=1", null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });


            if (obj == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            checkCustomerPhone(userIds, obj);
            return true;
        });
    }

    function checkCustomerPhone(userIds, customerIds) {
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhoneByCustomerIds",
            data: {
                userIds: userIds,
                customerIds: customerIds
            },
            async: true,
            type: "get",
            success: function (data) {
                if (data.result === "0") {
                    House365Util.createModal("提示,", data.msg + "<hr/>是否继续？", function () {
                        assignCustomer(userIds, customerIds);
                        return false;
                    });
                } else {
                    assignCustomer(userIds, customerIds);
                    return false;
                }
            }
        });
    }

    function assignCustomer(userIds, customerIds) {
        $.ajax({
            url: '${ctx}/rushcustomer/assign',
            data: {"userIds": userIds, "customerIds": customerIds},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    window.location.reload();
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }
</script>
</body>
</html>
