<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>驻场日报渠道管理</title>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">ReportChannel列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/reportchannel?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>驻场日报渠道管理
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/reportchannel" method="get">
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small" placeholder="名称">
                <select id="search_EQ_channelType" name="search_EQ_channelType">
                    <option value="">
                        全部渠道
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_channelType']}">selected="selected"</c:if>>
                        365渠道
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_EQ_channelType']}">selected="selected"</c:if>>
                        非365渠道
                    </option>
                </select>
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/reportchannel?action=create" class="btn blue pull-right" title="新增">
                        <i class="icon-plus"></i>
                    </a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">序号</th>
            <th width="100">名称</th>
            <th width="100">类型</th>
            <th width="100">部门</th>
            <th width="100">添加时间</th>
            <th width="100">状态</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${reportChannels}" var="reportChannel">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${reportChannel.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/reportchannel/${reportChannel.id}">
                        <c:if test="${null ne reportChannel.id && '' ne reportChannel.id}">
                            <c:out value="${reportChannel.id}"/>
                        </c:if>
                        <c:if test="${null eq reportChannel.id || '' eq reportChannel.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne reportChannel.name && '' ne reportChannel.name}">
                        <c:out value="${reportChannel.name}"/>
                    </c:if>
                    <c:if test="${null eq reportChannel.name || '' eq reportChannel.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne reportChannel.channelType && '' ne reportChannel.channelType}">
                        <c:choose>
                            <c:when test="${'1' eq reportChannel.channelType}">
                                365渠道
                            </c:when>
                            <c:when test="${'2' eq reportChannel.channelType}">
                                非365渠道
                            </c:when>
                        </c:choose>
                    </c:if>
                    <c:if test="${null eq reportChannel.channelType || '' eq reportChannel.channelType}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/reportchannel/${reportChannel.id}" title="${reportChannel.lastModifier}">
                        <c:if test="${null ne reportChannel.lastModifier && '' ne reportChannel.lastModifier}">
                            ${fn:substring(reportChannel.lastModifier, 0, 24)}...
                        </c:if>
                        <c:if test="${null eq reportChannel.lastModifier || '' eq reportChannel.lastModifier}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne reportChannel.createTime && '' ne reportChannel.createTime}">
                        <f:formatDate value='${reportChannel.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq reportChannel.createTime || '' eq reportChannel.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne reportChannel.status && '' ne reportChannel.status}">
                        <c:choose>
                            <c:when test="${'1' eq reportChannel.status}">
                                启用
                            </c:when>
                            <c:when test="${'2' eq reportChannel.status}">
                                禁用
                            </c:when>
                            <c:when test="${'3' eq reportChannel.status}">
                                无效
                            </c:when>
                        </c:choose>
                    </c:if>
                    <c:if test="${null eq reportChannel.status || '' eq reportChannel.status}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="window.location='${ctx}/reportchannel/${reportChannel.id}?action=edit'"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${reportChannel.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        }
        else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/reportchannel/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
