<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<html>
<head>
    <title>营销活动列表</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active">
                <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                营销活动列表
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/marketingactivity" method="get">
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small" placeholder="活动名称">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/marketingactivity/step1?action=create" class="btn blue pull-right" title="新增">
                        <i class="icon-plus"></i>
                    </a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="30">id</th>
            <th width="100">活动名称</th>
            <th width="100">来源条件</th>
            <th width="100">创建人</th>
            <th width="100">待派</th>
            <th width="100">已派</th>
            <th width="100">超时</th>
            <th width="100">放弃</th>
            <th width="100">回访</th>
            <th width="100">创建时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${marketingActivitys}" var="marketingActivity">
            <tr>
                <td nowrap="nowrap">
                    <a href="${ctx}/marketingactivity/step1/${marketingActivity.id}?action=edit" target="_blank">
                        <c:if test="${null ne marketingActivity.id && '' ne marketingActivity.id}">
                            <c:out value="${marketingActivity.id}"/>
                        </c:if>
                        <c:if test="${null eq marketingActivity.id || '' eq marketingActivity.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.name && '' ne marketingActivity.name}">

                        <c:choose>
                            <c:when test="${marketingActivity.notAssign gt 0}">
                                <span style="color: red"><c:out value="${marketingActivity.name}"/></span>
                            </c:when>
                            <c:otherwise>
                                <c:out value="${marketingActivity.name}"/>
                            </c:otherwise>
                        </c:choose>

                    </c:if>
                    <c:if test="${null eq marketingActivity.name || '' eq marketingActivity.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="javascript:void(0);" class="baobei">${marketingActivity.descSub}</a>
                    <%--<a href="javascript:void(0);" class="baobei">${fns:substringLeft(marketingActivity.desc,16)}</a>--%>
                    <div style="display: none;">
                        <c:if test="${not empty marketingActivity.desc}">
                            ${marketingActivity.desc}
                        </c:if>
                    </div>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.createName && '' ne marketingActivity.createName}">
                        <c:out value="${marketingActivity.createName}"/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.createName || '' eq marketingActivity.createName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.notAssign && '' ne marketingActivity.notAssign}">

                        <c:choose>
                            <c:when test="${marketingActivity.notAssign gt 0}">
                                <span style="color: red"><c:out value="${marketingActivity.notAssign}"/></span>
                            </c:when>
                            <c:otherwise>
                                <c:out value="${marketingActivity.notAssign}"/>
                            </c:otherwise>
                        </c:choose>

                    </c:if>
                    <c:if test="${null eq marketingActivity.notAssign || '' eq marketingActivity.notAssign}">
                        &nbsp;0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.assign && '' ne marketingActivity.assign}">
                        <c:out value="${marketingActivity.assign}"/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.assign || '' eq marketingActivity.assign}">
                        &nbsp;0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.overTimeCount && '' ne marketingActivity.overTimeCount}">
                        <c:out value="${marketingActivity.overTimeCount}"/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.overTimeCount || '' eq marketingActivity.overTimeCount}">
                        &nbsp;0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.abandon && '' ne marketingActivity.abandon}">
                        <c:out value="${marketingActivity.abandon}"/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.abandon || '' eq marketingActivity.abandon}">
                        &nbsp;0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.visitBackCount && '' ne marketingActivity.visitBackCount}">
                        <c:out value="${marketingActivity.visitBackCount-marketingActivity.callAbandon}"/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.visitBackCount || '' eq marketingActivity.visitBackCount}">
                        &nbsp;0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne marketingActivity.createTime && '' ne marketingActivity.createTime}">
                        <f:formatDate value='${marketingActivity.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq marketingActivity.createTime || '' eq marketingActivity.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/marketingactivity/copyStep2/${marketingActivity.id}"  target="_blank">复制</a>
                    <%--<a href="javascript:void(0);" onclick="copyStep2('${marketingActivity.id}', '${marketingActivity.type}')">复制</a>--%>
                    <a href="${ctx}/marketingactivity/step1/${marketingActivity.id}?action=edit" target="_blank">查看</a>
                    <a href="${ctx}/marketcustomer?search_EQ_activeId=${marketingActivity.id}" target="_blank">数据详情</a>
                    <a href="javascript:void(0);" onclick="deleteById('${marketingActivity.id}')">删除</a>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script type="text/javascript">

    $(function () {
        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                }, position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });
    });

    <%--function copyStep2(name, type){--%>
        <%--$.ajax({--%>
            <%--url: '${ctx}/marketingactivity/delete/' + selectedId,--%>
            <%----%>
        <%--});--%>
    <%--}--%>

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除", "请至少选择一条纪录!", function () {
            });
        }
        else {
            House365Util.createModal("删除", "确定要删除该活动？", function () {
                $.ajax({
                    url: '${ctx}/marketingactivity/delete/' + selectedId,
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
