<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/dictionary/removeTime<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/dictionary/removeTime/removeTimeList">列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/dictionary/removeTime/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/dictionary/removeTime/removeTimeList" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/dictionary/removeTime/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/dictionary/removeTime/removeTimeList" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">配置项标识:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' }">
                                        <select name="entity.dicKey" onchange="selectDicKey(this.value)">
                                            <option></option>
                                            <option value="customer.remove.days.order">新增>>>到访时间</option>
                                            <option value="customer.remove.days.visit">到访>>>认筹时间</option>
                                            <option value="customer.remove.days.all">所有状态>>>认筹时间</option>
                                            <option value="customer.remove.days.noVisit">N天无回访（且未到访）</option>
                                        </select>
                                        <span color="red"><form:errors path="dictionaryVo.entity.dicKey"/></span>
                                    </c:when>
                                    <c:when test="${ action=='edit'}">
                                        <span class="inline">${entity.dicKey}&nbsp;</span>
                                        <input type="hidden" name="entity.dicKey" value="${entity.dicKey}"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.dicKey}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">配置项名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' }">
                                        <input type="text" id="dicName"
                                               name="entity.dicName"
                                               value="${entity.dicName}" readonly/>
                                        <span color="red"><form:errors path="dictionaryVo.entity.dicName"/></span>
                                    </c:when>
                                    <c:when test="${ action=='edit'}">
                                        <input type="text" id="entity.dicName"
                                               name="entity.dicName" readonly
                                               value="${entity.dicName}"/>
                                        <span color="red"><form:errors path="dictionaryVo.entity.dicName"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.dicName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">回公海时间(天):</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number required"
                                               id="entity.dicValue"
                                               name="entity.dicValue" value="${entity.dicValue}">

                                        <span color="red"><form:errors path="dictionaryVo.entity.dicValue"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.dicValue}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                                <input type="hidden" name="entity.city" value="${entity.city}"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
    function selectDicKey(_dicKey) {
        var dicName = "";
        if (_dicKey === "customer.remove.days.order") {
            dicName = "新增>>>到访时间";
        } else if (_dicKey === "customer.remove.days.visit") {
            dicName = "到访>>>认筹时间";
        }else if (_dicKey === "customer.remove.days.noVisit") {
            dicName = "N天无回访（且未到访）";
        }
        $("#dicName").val(dicName);
    }
</script>
</body>
</html>
