<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>部门列表</title>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">部门列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/department?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>部门列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/department" method="get">
                <input type="text" name="search_LIKE_id" value="${param['search_LIKE_id']}"
                       class="m-wrap small span2" placeholder="id">
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="部门名称">
                <input type="text" name="search_LIKE_urlPath" value="${param['search_LIKE_urlPath']}"
                       class="m-wrap small span2" placeholder="url path">
                <input type="text" name="search_LIKE_type" value="${param['search_LIKE_type']}"
                       class="m-wrap small span2" placeholder="部门类型">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/department?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">部门名称</th>
            <th width="100">url path</th>
            <th width="100">部门类型</th>
            <th width="100">父部门</th>
            <th width="100">在父部门中的次序值</th>
            <th width="100">创建时间</th>
            <th width="100">修改时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${departments}" var="department">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${department.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/department/${department.id}"> <c:if
                            test="${null ne department.id && '' ne department.id}">
                        <c:out value="${department.id}"/>
                    </c:if>
                        <c:if test="${null eq department.id || '' eq department.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.name && '' ne department.name}">
                        <c:out value="${department.name}"/>
                    </c:if>
                    <c:if test="${null eq department.name || '' eq department.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.urlPath && '' ne department.urlPath}">
                        <c:out value="${department.urlPath}"/>
                    </c:if>
                    <c:if test="${null eq department.urlPath || '' eq department.urlPath}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.type && '' ne department.type}">
                        <c:out value="${department.type}"/>
                    </c:if>
                    <c:if test="${null eq department.type || '' eq department.type}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.parentId && '' ne department.parentId}">
                        <c:out value="${department.parentId}"/>
                    </c:if>
                    <c:if test="${null eq department.parentId || '' eq department.parentId}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.order && '' ne department.order}">
                        <c:out value="${department.order}"/>
                    </c:if>
                    <c:if test="${null eq department.order || '' eq department.order}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.createTime && '' ne department.createTime}">
                        <f:formatDate value='${department.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq department.createTime || '' eq department.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne department.updateTime && '' ne department.updateTime}">
                        <f:formatDate value='${department.updateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq department.updateTime || '' eq department.updateTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="window.location='${ctx}/department/${department.id}?action=edit'"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${department.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        }
        else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/department/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
