<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/customermanagement/myCustomerNew">我的客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.name} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.name}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row-fluid">
        <c:if test="${displayBackToSeaDate == true}">
            <div class="span12">
                <span style="position: absolute;left: 40%;border-style: solid;padding: 20px;border-width: thin;border-color: #FFEED3;background-color: #FCF8E4;color: #896C3F;">客户将在<c:out
                        value="${backToSeaDate}"/>返回公海，请及时跟进</span>
            </div>
        </c:if>
    </div>

    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle" style="height:30px;">
                        客户属性
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="entity.remark" id="entity_remark" type="hidden" value="${entity.remark}"/>
                    <input id="hiddenBuyIntention" name="entity.buyIntention" type="hidden"
                           value="${entity.buyIntention}"/>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                <input disabled type="radio" name="customerSourceType" value="1" <c:if
                                        test="${entity.customerSourceType eq '1' && entity.status ne '0'}">
                                       checked</c:if>>常规
                                <input disabled type="radio" name="customerSourceType" value="2" <c:if
                                        test="${entity.customerSourceType eq '2'}"> checked</c:if>>抢客
                                <input disabled type="radio" name="customerSourceType" value="3" <c:if
                                        test="${entity.customerSourceType eq '3'}"> checked</c:if>>营销
                                <input disabled type="radio" name="createSource" value="HOTLINE" <c:if
                                        test="${entity.createSource eq 'HOTLINE' && entity.status eq '0'}">
                                       checked</c:if>>400进线
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><font color="red">*</font> 客户姓名:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}"/>
                                        <font color="red"><form:errors path="customerVo.entity.name"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose><br>
                                <a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                                <c:if test="${hasPhone == 1}">
                                    <span id="star" class="icon-phone-sign"
                                          onclick="callCustomer('${entity.phone}','${entity.id}','${entity.buyIntention}','0','${entity.isPeer}')"></span>
                                </c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <input type="radio" name="entity.sex" value="2" <c:if test="${entity.sex eq '2'}">
                                       checked</c:if>>未知
                                <input type="radio" name="entity.sex" value="1" <c:if test="${entity.sex eq '1'}">
                                       checked</c:if>>男
                                <input type="radio" name="entity.sex" value="0" <c:if test="${entity.sex eq '0'}">
                                       checked</c:if>>女
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone1"
                                               name="entity.bakPhone1" maxlength="11"
                                               value="${entity.bakPhone1}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone1"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone1}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">其他号码2:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone2"
                                               name="entity.bakPhone2" maxlength="11"
                                               value="${entity.bakPhone2}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone2"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone2}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码3:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone3"
                                               name="entity.bakPhone3" maxlength="11"
                                               value="${entity.bakPhone3}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone3"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone3}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">跟踪状态:</label>
                            <div class="controls">
                                <select name="entity.traceStatus" id="traceStatus">
                                    <option value="1"
                                            <c:if test="${'1' eq entity.traceStatus}">selected="selected"</c:if>>
                                        有效
                                    </option>
                                    <option value="2"
                                            <c:if test="${'2' eq entity.traceStatus}">selected="selected"</c:if>>
                                        已购
                                    </option>
                                    <option value="3"
                                            <c:if test="${'3' eq entity.traceStatus}">selected="selected"</c:if>>
                                        我购
                                    </option>
                                    <option value="4"
                                            <c:if test="${'4' eq entity.traceStatus}">selected="selected"</c:if>>
                                        暂缓
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span9 control-group">
                            <label class="control-label">备注:</label>
                            <div class="controls">
                                <shiro:hasPermission name="FUNC:ADDCALL">
                                    <button type="button" class="btn btn-default"
                                            onclick="addCallBack()">
                                        添加回访
                                    </button>
                                </shiro:hasPermission>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户图片：（<font color="red">注意：上传前请先保存填写的数据，上传文件将刷新页面，如未保存数据将丢失！</font>）
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <div class="span3">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_customer"
                                                   bizType="${nextBizType}" editAble="true" title="图标"
                                                   maxSize="1"/>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:forEach items="${baseAttachments}" var="pic">
                                <div class="span2" style="width: 18%;">
                                    <tags:imageSection resourceId="${pic.resourceId}"
                                                       resourceType="hgs_customer"
                                                       bizType="${pic.bizType}" editAble="true" title="图标"
                                                       maxSize="1"/>
                                </div>
                            </c:forEach>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        回访记录
                    </div>
                    <div class="row-fluid">
                        <div class="span8 control-group offset1">
                            回访内容
                        </div>
                        <div class="span1 control-group">
                            添加人
                        </div>
                        <div class="span2 control-group">
                            添加日期
                        </div>
                    </div>

                    <c:forEach items="${callLogs}" var="call">
                        <div class="row-fluid">
                            <div class="span8 control-group offset1" style="overflow: auto;">
                                    ${call.content}
                            </div>
                            <div class="span1 control-group">
                                    ${call.managerName}
                            </div>
                            <div class="span2 control-group">
                                <fmt:formatDate value='${call.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                            </div>
                        </div>
                    </c:forEach>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                        </div>
                        <div class="span4 control-group">
                            <a href="${ctx}/customercallbacklog?customerId=${entity.id}" target="_blank">查看更多回访纪录</a>
                        </div>
                        <div class="span2 control-group">
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">购房意向：</label>
                            <div class="controls">
                                <span class="inline">
                                    <c:choose>
                                        <c:when test="${entity.buyIntention eq '1'}">
                                            <span class="inline">A</span>
                                        </c:when>
                                        <c:when test="${entity.buyIntention eq '2'}">
                                            <span class="inline">B</span>
                                        </c:when>
                                        <c:when test="${entity.buyIntention eq '3'}">
                                            <span class="inline">C</span>
                                        </c:when>
                                        <c:when test="${entity.buyIntention eq '4'}">
                                            <span class="inline">D</span>
                                        </c:when>
                                        <c:when test="${entity.buyIntention eq '5'}">
                                            <span class="inline">E(丢入公海)</span>
                                        </c:when>
                                        <c:otherwise>
                                            <span class="inline">待定</span>
                                        </c:otherwise>
                                    </c:choose>
                                </span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">活动来源：</label>
                            <div class="controls">
                                <%--<span class="inline">${entity.actSource}&nbsp;</span>--%>
                                <span class="inline">${fn:replace(entity.actSource," ","&nbsp;")}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">初次来源:</label>
                            <div class="controls">
                                <span class="inline">${entity.firstSource}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">最近来源:</label>
                            <div class="controls">
                                <span class="inline">${entity.latestSource}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">最近回访:</label>
                            <div class="controls">
                                <span class="inline">${entity.crmLatestCall}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">最近回访结果:</label>
                            <div class="controls">
                                <span class="inline">${entity.crmLatestCallResult}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        约看信息
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <table style="width: 100%;">
                                <c:forEach items="${customerProjects}" var="cp">
                                    <tr class="header expand" style="line-height: 30px;background-color: #EEEEEE;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>约看项目：${cp.projectName} <a
                                                href="${ctx}/customer/updateProjectInfo/${cp.id}"
                                                target="_blank">查看约看详情</a>
                                        </td>
                                        <td>客户状态：
                                            <c:if test="${not empty cp.status}">
                                                <c:choose>
                                                    <c:when test="${cp.status eq '1'}">
                                                        <span class="inline">约看</span>
                                                    </c:when>
                                                    <c:when test="${cp.status eq '2'}">
                                                        <span class="inline">到访</span>
                                                    </c:when>
                                                    <c:when test="${cp.status eq '3'}">
                                                        <span class="inline">认筹</span>
                                                    </c:when>
                                                    <c:when test="${cp.status eq '4'}">
                                                        <span class="inline">认购</span>
                                                    </c:when>
                                                    <c:when test="${cp.status eq '5'}">
                                                        <span class="inline">签约</span>
                                                    </c:when>
                                                    <c:when test="${cp.status eq '6'}">
                                                        <span class="inline">退房</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                            <font color="red">${cp.remark}</font>
                                        </td>
                                        <td><span class="sign"></span></td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>到访次数：${cp.visitTime}</td>
                                        <td>案场报备：
                                            <c:if test="${not empty cp.recordedStatus}">
                                                <c:choose>
                                                    <c:when test="${cp.recordedStatus eq '1'}">
                                                        <span class="inline">无效</span>
                                                    </c:when>
                                                    <c:when test="${cp.recordedStatus eq '0'}">
                                                        <span class="inline">有效</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                            <c:if test="${empty cp.recordedStatus}">
                                                <span class="inline">待定</span>
                                            </c:if>
                                        </td>
                                        <td>贷款状态：
                                            <c:if test="${not empty cp.loanStatus}">
                                                <c:choose>
                                                    <c:when test="${cp.loanStatus eq '0'}">
                                                        <span class="inline">未办理</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '1'}">
                                                        <span class="inline">申请中</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '2'}">
                                                        <span class="inline">已下款</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '3'}">
                                                        <span class="inline">被拒绝</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '4'}">
                                                        <span class="inline">全款支付</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                        </td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>需求面积段：${cp.requireArea}</td>
                                        <td>意向房型：${cp.requireHouseType}</td>
                                        <td>需求房号：${cp.requireHouse}</td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>总价预算：${cp.requirePrice}</td>
                                        <td>约看时间：
                                            <c:if test="${null ne cp.recordedTime}">
                                                <f:formatDate value='${cp.recordedTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </c:if>
                                        </td>
                                        <td></td>
                                    </tr>
                                </c:forEach>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="portlet-header">
                <div class="operation-btn">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <input class="btn blue" type="button" onclick="commitForm()" value="保存">
                            </input>
                            <a href="#" class="btn gray" onclick="assignHouseSingle(${entity.id})">&nbsp;约看客户</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/customer" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/customer/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/customer" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
    });

    function setCallbackContent(template) {

        var content = $(template).text();
        $('.callback-content').val(content);
    }

    function commitForm() {
        var phone1 = $("#entity_bakPhone1").val();
        var phone2 = $("#entity_bakPhone2").val();
        var phone3 = $("#entity_bakPhone3").val();
        if (phone1 != "" && !checkMobile(phone1)) {
            House365Util.createModal("提示", "其他号码1格式不正确", function () {
                $("#entity_bakPhone1").focus();
            });
            return false;
        }
        if (phone2 != "" && !checkMobile(phone2)) {
            House365Util.createModal("提示", "其他号码2格式不正确", function () {
                $("#entity_bakPhone2").focus();
            });
            return false;
        }
        if (phone3 != "" && !checkMobile(phone3)) {
            House365Util.createModal("提示", "其他号码3格式不正确", function () {
                $("#entity_bakPhone3").focus();
            });
            return false;
        }

        var buyIntention = $("#hiddenBuyIntention").val();

        if (buyIntention == 5) {
            House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                $("#input_form").submit();
            });
        }

        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function assignHouseSingle(obj) {
        $.ajax({
            url: '/house365-hgs-web/customer/judgeSee',
            data: {
                "customerIds": obj
            },
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    House365Util.createRemoteModal("", "${ctx}/customer/assignProject?customerId=" + obj, null, function () {
                        var userIds = "";
                        if ($("#custom-headers").find("option:selected").length == 0) {
                            alert("约看项目不可为空!");
                            return false;
                        }

                        $("#custom-headers").find("option:selected").each(function () {
                            userIds = userIds + $(this).val() + ",";
                        });

                        if (obj == '') {
                            alert("至少要选择一个客户!");
                            return false;
                        }

                        $.ajax({
                            url: '${ctx}/customer/bindProject',
                            data: {"projectIds": userIds, "customerIds": obj},
                            type: "GET",
                            success: function (data) {
                                if (data.result == '1') {
                                    window.location.reload();
                                } else {
                                    alert("操作失败，" + data.msg);
                                }
                            }
                        });
                        return true;
                    });
                } else {
                    alert(data.errorMessage);
                }
            }
        });

    }

    function addCallBack() {
        var callContentHtml = "";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls'><select name='entity.buyIntention' id='buyIntention'>"
            + "<option value=''";
        <c:if test="${null eq entity.buyIntention or '' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">待定</option><option value='5'";
        <c:if test="${'5' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">E(丢入公海)</option><option value='4'";
        <c:if test="${'4' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">D</option><option value='3'";
        <c:if test="${'3' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">C</option><option value='2'";
        <c:if test="${'2' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">B</option><option value='1'";
        <c:if test="${'1' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">A</option>";
        callContentHtml += "</select></div></div></div>";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<textarea class='callback-content' cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'></textarea>"
            + "</div></div>";

        callContentHtml += "<div style='margin-top: 10px;'>"
        callContentHtml += "<c:forEach items='${callbackTemplateList}' var='item'>";
        callContentHtml += "<button type='button' class='btn' style='margin: 5px' onclick='setCallbackContent(this)'>${item.content}</button>";
        callContentHtml += "</c:forEach>";
        callContentHtml += "</div>";

        callContentHtml += "<div style='margin-top: 10px;'>" + "<span>回访提醒：</span>";
        callContentHtml += "<input type='text' style='width: 200px;' autocomplete='off' class='datetime-picker span2 input-large' id='returnTime' date-language='zh-CN' date-format='yyyy-mm-dd hh:ii:ss' placeholder='/年/月/日'>";
        callContentHtml += "</div>";

        var peer = ${entity.isPeer};
        if (peer == 0) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer' value='0' checked>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1'>" + "是" + "</div></div>";
        } else if (peer == 1) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer' value='0'>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1' checked>" + "是" + "</div></div>";
        }

        House365Util.createModal("添加回访", callContentHtml, function () {
            var callContent = $("#callContent").val();
            var buyIntention = $("#buyIntention").val();
            var isPeer = $("input[name='isPeer']:checked").val();
            var customerId = ${entity.id};
            var returnTime = $("#returnTime").val();
            if (returnTime != null && returnTime != '') {
                var date = new Date();
                var date1 = new Date(returnTime);
                if (date.getTime() > date1.getTime()) {
                    alert("回访提醒时间不能小于当前时间");
                    return;
                }
            }

            $("#hiddenBuyIntention").val(buyIntention);
            if (!callContent) {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else if (buyIntention == 5) {
                House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                    $.ajax({
                        url: '${ctx}/customer/addCall',
                        data: {
                            "content": callContent,
                            "customerId": ${entity.id},
                            "buyIntention": buyIntention
                        },
                        type: "GET",
                        success: function (data) {
                            if (data.result == '1') {
                                window.location.href = "${ctx}/customer/";
                            } else {
                                alert("操作失败，" + data.msg);
                            }
                        }
                    });
                    //更新客户是否中介同行状态
                    $.ajax({
                        url: '${ctx}/customermanagement/updatePeerAndTime',
                        contentType: 'application/json',
                        data: JSON.stringify({
                            id: customerId,
                            isPeer: isPeer,
                            buyIntention: buyIntention,
                            returnRemindTime: returnTime
                        }),
                        dataType: 'json',
                        type: "POST",
                        success: function (data) {
                            if (data.status == 0) {
                                window.location.reload();
                            } else {
                                alert(data.errorMessage);
                            }
                        }
                    });
                });
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": ${entity.id},
                        "buyIntention": buyIntention
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            window.location.reload();
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
                //更新客户是否中介同行状态
                $.ajax({
                    url: '${ctx}/customermanagement/updatePeerAndTime',
                    contentType: 'application/json',
                    data: JSON.stringify({
                        id: ${entity.id},
                        isPeer: isPeer,
                        returnRemindTime: returnTime
                    }),
                    dataType: 'json',
                    type: "POST",
                    success: function (data) {
                        if (data.status == 0) {
                            window.location.reload();
                        } else {
                            alert(data.errorMessage);
                        }
                    }
                });
            }
        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    var curnet = "${sessionUser.cornet}";

    function callCustomer(memPhone, customerId, buyIntention, abandon, isPeer) {
        $.ajax({
            url: "${ctx}/cityCall/judgeCall",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    if (curnet == "") {
                        House365Util.createModal("电话回访",
                            "对不起，您尚未填写固定电话短号，请前往个人中心设置", function () {
                                window.location.href = "${ctx}/role/edit/${sessionUserId}";
                            }, "前往设置");
                        return;
                    }

                    $("#callDialog").load("${ctx}/customermanagement/callCustomer?memPhone=" + memPhone + "&customerId=" + customerId
                        + "&buyIntention=" + buyIntention + "&abandon=" + abandon + "&isPeer=" + isPeer, null, function () {

                        $("#returnTime2").datetimepicker({
                            format: 'yyyy-mm-dd hh:ii:ss',
                            maxView: "decade",
                            minView: "hour",
                            startView: "month",
                            autoclose: true,
                            language: 'zh-CN',
                            viewSelect: "decade",
                            minuteStep: 10,
                            pickerPosition: "bottom-left"
                        });
                    });
                    $("#callDialog").dialog({
                        closeOnEscape: false,
                        autoOpen: false,
                        draggable: false,
                        modal: true,
                        open: function (event, ui) {
                            $(".ui-dialog-titlebar-close", $(this).parent()).hide();
                        },
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        }
                    }).dialog("open");
                }
            }
        });
    }

</script>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>

<div id="callDialog" style="display: none" title="电话回访"></div>

</body>

</html>
