<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/citydepconfig<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/citydepconfig">项目日报-城市部门配置表列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="button" onclick="formSubmit();">
                                <i class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/citydepconfig/${entity.id}" class="btn gray">
                                <i class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button type="button" class="btn blue" onclick="formSubmit();">
                                <i class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/citydepconfig" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/citydepconfig/${entity.id}?action=edit" class="btn blue">
                                <i class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/citydepconfig" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">城市 :</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">

                                        <select name="entity.city" id="city"
                                                class="span10 nochosen  multiselect required"
                                                data-placeholder="城市">
                                            <option value="">请选择城市</option>
                                            <c:forEach items="${cityList}" var="c">
                                                <option value="${c.id}"
                                                        <c:if test="${'1' eq c.type}">selected="selected"</c:if>>${c.name}</option>
                                            </c:forEach>
                                        </select>

                                        <font color="red"><form:errors path="cityDepConfigVo.entity.city"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.city}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">部门 :</label>
                            <div class="controls" id="deptDiv">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">

                                        <select name="entity.dept" id="department"
                                                class="span10 nochosen  multiselect required"
                                                multiple="multiple"
                                                data-placeholder="部门">
                                        </select>

                                        <font color="red"><form:errors path="cityDepConfigVo.entity.dept"/></font>

                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.dept}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</form>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>

<script type="text/javascript">
    $(document).ready(function () {

        $('#city').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 1,
            filterPlaceholder: '请输入城市名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择城市 ';
                } else if (options.length > 1) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }

            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
                var selectedOptions = $('#city option:selected');

                if (selectedOptions.val()) {
                    $.ajax({
                        url: "${ctx}/department/getByCity",
                        type: "GET",
                        data: {city: selectedOptions.val(), "type": "channelReport"},
                        dataType: "json",
                        success: function (data) {
                            var dept = $('#department');
                            $(data).each(function () {
                                if (this.type == '1') {
                                    dept.append("<option value='" + this.id + "' selected>" + this.name + "</option>");
                                } else {
                                    dept.append("<option value='" + this.id + "'>" + this.name + "</option>");
                                }
                            });
                            initDepart();
                        }
                    });
                } else {
                    initDepart();
                }
//
//                if (selectedOptions.length >= 1) {
//                    var nonSelectedOptions = $('#city option').filter(function () {
//                        return !$(this).is(':selected');
//                    });
//
//                    var dropdown = $('#city').siblings('.open');
//                    nonSelectedOptions.each(function () {
//                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
//                        input.prop('disabled', true);
//                        input.parent('li').addClass('disabled');
//                    });
//                }
//                else {
//                    var dropdown = $('#city').siblings('.open');
//                    $('#city option').each(function () {
//                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
//                        input.prop('disabled', false);
//                        input.parent('li').addClass('disabled');
//                    });
//                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#city option:selected');
                var contain = $('#deptDiv');
                contain.empty();
                contain.append("<select name=\"entity.dept\" id=\"department\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"部门\">\n" +
                    "                                        </select>");

//                if (selectedOptions.length >= 1) {
//                    var nonSelectedOptions = $('#city option').filter(function () {
//                        return !$(this).is(':selected');
//                    });
//
//                    var dropdown = $('#city').siblings('.open');
//                    nonSelectedOptions.each(function () {
//                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
//                        input.prop('disabled', true);
//                        input.parent('li').addClass('disabled');
//                    });
//                }
//                else {
//                    var dropdown = $('#city').siblings('.open');
//                    $('#city option').each(function () {
//                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
//                        input.prop('disabled', false);
//                        input.parent('li').addClass('disabled');
//                    });
//                }

                if (selectedOptions.val()) {
                    $.ajax({
                        url: "${ctx}/department/getByCity",
                        type: "GET",
                        data: {city: selectedOptions.val()},
                        dataType: "json",
                        success: function (data) {
                            var dept = $('#department');
                            $(data).each(function () {
                                dept.append("<option value='" + this.id + "'>" + this.name + "</option>");
                            });
                            initDepart();
                        }
                    });
                } else {
                    initDepart();
                }

            }
        });


    });

    function initDepart() {

        $('#department').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 5,
            filterPlaceholder: '请输入部门名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择部门 ';
                } else if (options.length > 5) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }

            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
                var selectedOptions = $('#department option:selected');

                if (selectedOptions.length >= 100) {
                    var nonSelectedOptions = $('#department option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#department').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#department').siblings('.open');
                    $('#department option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#department option:selected');
                if (selectedOptions.length >= 100) {
                    var nonSelectedOptions = $('#department option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#department').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                } else {
                    var dropdown = $('#department').siblings('.open');
                    $('#department option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });
    }

    function formSubmit() {
        var city = ",";
        var dept = ",";
        $("#city").find("option:selected").each(function () {
            city = city + $(this).val() + ",";
        });
        $("#department").find("option:selected").each(function () {
            dept = dept + $(this).val() + ",";
        });
        if (city == "," || dept == ",") {
            House365Util.createModal("请选择", "请选择城市和部门", function () {
            });
            return false;
        }

        $('#input_form').submit();
    }
</script>

</body>

</html>
