package com.house365.web.util;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerLogEntity;
import com.house365.ws.interfaces.server.ICustomer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author whh
 */
@Component
public class MergeCustomerUtil {

    @Autowired
    private ICustomer customer;


    /**
     * 更新合并客户
     *
     * @param customerEntity 旧的客户实体
     * @param oldEntity      新表客户实体
     * @return
     */
    public boolean checkMergeCustomer(CustomerEntity customerEntity, CustomerEntity oldEntity, Integer userId, String userName) {
        String oldbuyIntension = oldEntity.getBuyIntention();
        Integer oldtracestatus = oldEntity.getTraceStatus();
        String buyIntension = "".equals(customerEntity.getBuyIntention()) ? "" : customerEntity.getBuyIntention();
        Integer tracestatus = customerEntity.getTraceStatus();

        //记录日志需要字段
        String oldBuyIntention = oldEntity.getBuyIntention();
        Integer oldTrcStatus = oldEntity.getTraceStatus();
        boolean needupdate = false;
        if (oldbuyIntension == null || "".equals(oldbuyIntension)) {
            oldEntity.setBuyIntention(String.valueOf(buyIntension));
            needupdate = true;
        } else if (buyIntension != null && !"".equals(buyIntension) && Integer.valueOf(buyIntension) < Integer.valueOf(oldbuyIntension)) {
            oldEntity.setBuyIntention(String.valueOf(buyIntension));
            needupdate = true;
        }
        if (tracestatus != 4 && tracestatus > oldtracestatus) {
            oldEntity.setTraceStatus(tracestatus);
            needupdate = true;
        }

        //合并客户时记录新客户表的日志(更新才记录)
        String newBuyIntention = oldEntity.getBuyIntention();
        Integer newTraceStatus = oldEntity.getTraceStatus();
        if (needupdate) {
            if (StringUtils.isNotBlank(oldbuyIntension) && StringUtils.isNotBlank(newBuyIntention) && !oldbuyIntension.equals(newBuyIntention)) {
                CustomerLogEntity logEntity = new CustomerLogEntity();

                logEntity.setRelateId(oldEntity.getId());
                logEntity.setCustomerPhone(oldEntity.getPhone());
                if (oldEntity.getManagerId() != null) {
                    logEntity.setManagerId(oldEntity.getManagerId());
                } else {
                    logEntity.setManagerId(0);
                }
                logEntity.setModifyName("购房意向");

                logEntity.setModifyColumn("buyIntention");
                logEntity.setType(2);
                logEntity.setOldValue(oldBuyIntention);
                logEntity.setNewValue(newBuyIntention);
                if ("1".equals(oldBuyIntention)) {
                    logEntity.setOldValue("A");
                } else if ("2".equals(oldBuyIntention)) {
                    logEntity.setOldValue("B");
                } else if ("3".equals(oldBuyIntention)) {
                    logEntity.setOldValue("C");
                } else if ("4".equals(oldBuyIntention)) {
                    logEntity.setOldValue("D");
                } else if ("5".equals(oldBuyIntention)) {
                    logEntity.setOldValue("E");
                }

                if ("1".equals(newBuyIntention)) {
                    logEntity.setNewValue("A");
                } else if ("2".equals(newBuyIntention)) {
                    logEntity.setNewValue("B");
                } else if ("3".equals(newBuyIntention)) {
                    logEntity.setNewValue("C");
                } else if ("4".equals(newBuyIntention)) {
                    logEntity.setNewValue("D");
                } else if ("5".equals(newBuyIntention)) {
                    logEntity.setNewValue("E");
                }
                logEntity.setCreateUserId(userId);
                logEntity.setCreateUserName(userName);
                logEntity.setCreateTime(new Date());
                customer.saveLog(logEntity);
            }
            if (newTraceStatus != null && !oldTrcStatus.equals(newTraceStatus)) {
                CustomerLogEntity logEntity = new CustomerLogEntity();
                logEntity.setRelateId(oldEntity.getId());
                logEntity.setCustomerPhone(oldEntity.getPhone());
                if (oldEntity.getManagerId() != null) {
                    logEntity.setManagerId(oldEntity.getManagerId());
                } else {
                    logEntity.setManagerId(0);
                }

                logEntity.setModifyName("跟踪状态");
                logEntity.setModifyColumn("traceStatus");
                logEntity.setType(2);
                logEntity.setOldValue(oldTrcStatus.toString());
                logEntity.setNewValue(newTraceStatus.toString());
                if (oldTrcStatus == 1) {
                    logEntity.setOldValue("有效");
                } else if (oldTrcStatus == 2) {
                    logEntity.setOldValue("已购");
                } else if (oldTrcStatus == 3) {
                    logEntity.setOldValue("我购");
                } else if (oldTrcStatus == 4) {
                    logEntity.setOldValue("暂缓");
                }
                if (newTraceStatus == 1) {
                    logEntity.setNewValue("有效");
                } else if (newTraceStatus == 2) {
                    logEntity.setNewValue("已购");
                } else if (newTraceStatus == 3) {
                    logEntity.setNewValue("我购");
                } else if (newTraceStatus == 4) {
                    logEntity.setNewValue("暂缓");
                }
                logEntity.setCreateUserId(userId);
                logEntity.setCreateUserName(userName);
                logEntity.setCreateTime(new Date());
                customer.saveLog(logEntity);
            }
        }
        return needupdate;
    }
}
