package com.house365.web.util;

import java.util.LinkedList;
import java.util.List;


public class Constant {
    public final static String USER_NAME = "userName";
    public final static String USER_ID = "userId";
    public final static String CITY_ID = "cityId";
    public final static String CITY_NAME = "cityName";
    public final static Integer statu = 11;
    public final static String SESSION_LOCAL_USER = "localUser";
    public final static String HGS_SERVICE_CODE = "Hgs";
    public final static String WECHAT_HGS_SERVICE_CODE = "Wechat";

    /**
     * 状态 0 未约看 1 约看、2 到访、3 认筹、4 认购、5 签约、6 退房
     */
    public static enum CustomerStatusEnum {
        NORECORD("未约看", 0), RECORDED("约看", 1), VISITED("到访", 2), ORDERED("认筹", 3), BUY("认购", 4), SING("签约", 5), CANCEL(
                "退房", 6);

        private String msg;
        private int status;

        CustomerStatusEnum(String msg, int status) {
            this.msg = msg;
            this.status = status;
        }

        public static List<CustomerStatusEnum> getItemList() {
            List<CustomerStatusEnum> list = new LinkedList<Constant.CustomerStatusEnum>();
            list.add(RECORDED);
            list.add(VISITED);
            list.add(ORDERED);
            list.add(BUY);
            list.add(SING);
            list.add(CANCEL);
            return list;
        }

        public static String getMsgByStatus(int i) {
            switch (i) {
                case 0:
                    return NORECORD.getMsg();
                case 1:
                    return RECORDED.getMsg();
                case 2:
                    return VISITED.getMsg();
                case 3:
                    return ORDERED.getMsg();
                case 4:
                    return BUY.getMsg();
                case 5:
                    return SING.getMsg();
                case 6:
                    return CANCEL.getMsg();
                default:
                    return "";
            }
        }

        /**
         * @return the msg
         */
        public String getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(String msg) {
            this.msg = msg;
        }

        /**
         * @return the status
         */
        public int getStatus() {
            return status;
        }

        /**
         * @param status the status to set
         */
        public void setStatus(int status) {
            this.status = status;
        }
    }

    /**
     * 客户来源
     */
    public static enum CustomerSourceEnum {
        CRM("CRM"), SYSTEM("SYSTEM"), MANAGE("MANAGE"), HOTLINE("HOTLINE"), WECHAT("WECHAT");

        private String msg;

        CustomerSourceEnum(String msg) {
            this.msg = msg;
        }

        /**
         * @return the msg
         */
        public String getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(String msg) {
            this.msg = msg;
        }
    }


    //98 未跟踪 0 未约看 99 删除
    public static enum HotLineStatusEnum {
        INIT(98), NORECORD(0), DELETE(99);

        private Integer msg;

        HotLineStatusEnum(Integer msg) {
            this.msg = msg;
        }

        /**
         * @return the msg
         */
        public Integer getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(Integer msg) {
            this.msg = msg;
        }
    }

}
