/**
 * Description: 客户-置业顾问关联页面表单对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-03-14 下午 13:43:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CustomerUserEntity;

/**
 * 客户-置业顾问关联页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
public class CustomerUserVo{
	/**
	 * 客户-置业顾问关联实体
	 */
    @NotNull
    @Valid
	private CustomerUserEntity entity;
	

	/**
	 * 设置客户-置业顾问关联实体
	 * @param entity 客户-置业顾问关联实体
	 */
	public void setEntity(CustomerUserEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取客户-置业顾问关联实体
	 * @return 客户-置业顾问关联实体
	 */
	public CustomerUserEntity getEntity() {
		return this.entity;
	}
}