/**
 * Description: EvaluateUserCustomerLog数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-18 下午 15:41:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.po;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * EvaluateUserCustomerLog数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-18
 * @see
 * @since 1.0
 */
public class EvaluateUserCustomerLogPo extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 直销人员id
     */

    private Integer userId;

    /**
     * 直销人员姓名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String userName;

    /**
     * 楼盘id
     */

    private Integer projectId;

    /**
     * 楼盘名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String projectName;

    /**
     * 客户姓名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String customerName;

    /**
     * 评分
     */

    private Integer score;

    /**
     * 评价内容
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String content;

    private String contentTags;

    public String getContentTags() {
        return contentTags;
    }

    public void setContentTags(String contentTags) {
        this.contentTags = contentTags;
    }

    /**
     * 带看创建时间
     */

    private java.util.Date createTime;
    /**
     * 带看创建时间
     */

    private String createTimeStr;

    /**
     * 客户评价时间
     */

    private java.util.Date evaluateTime;

    /**
     * channel
     */

    private Integer channel;

    private String headImgURL;

    public String getHeadImgURL() {
        return headImgURL;
    }

    public void setHeadImgURL(String headImgURL) {
        this.headImgURL = headImgURL;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public Date getEvaluateTime() {
        return evaluateTime;
    }

    public void setEvaluateTime(Date evaluateTime) {
        this.evaluateTime = evaluateTime;
    }
}

