/**
 * Description: UserStar数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-05-15 下午 17:04:55
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-05-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * UserStar数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-05-15
 * @see
 * @since 1.0
 */
public class UserStarEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * userId
     */
    @NotNull
    private Integer userId;

    /**
     * starUserId
     */
    @NotNull
    private Integer starUserId;

    /**
     * 1 y - 0 n
     */
    @NotNull
    private Integer star;

    /**
     * createTime
     */
    @NotNull
    private java.util.Date createTime;

    //columns END
    /*
	public UserStar(){
	}

	public UserStar(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置userId
     * @param userId userId
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取userId
     * @return userId
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置starUserId
     * @param starUserId starUserId
     */
    public void setStarUserId(Integer starUserId) {
        this.starUserId = starUserId;
    }

    /**
     * 获取starUserId
     * @return starUserId
     */
    public Integer getStarUserId() {
        return this.starUserId;
    }

    /**
     * 设置1 y - 0 n
     * @param star 1 y - 0 n
     */
    public void setStar(Integer star) {
        this.star = star;
    }

    /**
     * 获取1 y - 0 n
     * @return 1 y - 0 n
     */
    public Integer getStar() {
        return this.star;
    }

    /**
     * 设置createTime
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("UserId", getUserId())
                .append("StarUserId", getStarUserId())
                .append("Star", getStar())
                .append("CreateTime", getCreateTime())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof UserStarEntity == false) return false;
        if (this == obj) return true;
        UserStarEntity other = (UserStarEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

