/**
 * Description: Project数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;


import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * Project数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public class ProjectEntity extends DomainObject {

    private static final long serialVersionUID = 1L;
    private String userName;
    private Integer userId;
    private Integer projectId;

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 合同号
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String contractCode;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 项目编号
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String projectCode;
    /**
     * 项目名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String projectName;

    /**
     * 关联楼盘ID
     */
    private Integer buildingId;

    private Integer dynamicId;

    private String dynamicContent;

    private List picList;

    public Integer getDynamicId() {
        return dynamicId;
    }

    public void setDynamicId(Integer dynamicId) {
        this.dynamicId = dynamicId;
    }

    public String getDynamicContent() {
        return dynamicContent;
    }

    public void setDynamicContent(String dynamicContent) {
        this.dynamicContent = dynamicContent;
    }

    public List getPicList() {
        return picList;
    }

    public void setPicList(List picList) {
        this.picList = picList;
    }

    /**
     * 关联楼盘名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String buildingName;
    /**
     * 项目状态 1 默认 2 执行中 3 办结 4 终止 5 立项审核中 6 删除
     */
    private Integer status;
    /**
     * 1 开启 0 关闭
     */
    private Integer showStatus;
    /**
     * 项目经理名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String manager;
    /**
     * 物业类型
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String type;
    /**
     * 开发商
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String kfs;
    private String city;
    private String cityName;
    private String district;
    private String business;
    /**
     * 地址
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String address;
    /**
     * 开盘时间
     */
    private java.util.Date startTime;
    /**
     * 房源状况
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String source;
    /**
     * 即时销售信息
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String jitInfo;
    /**
     * 佣金标准
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String hireMoney;
    /**
     * 创建人用户ID
     */

    private Integer createUserid;
    /**
     * 创建人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String createUsername;
    /**
     * 创建时间
     */

    private java.util.Date createTime;
    /**
     * 创建人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String createIp;
    /**
     * 最后一次修改人用户ID
     */

    private Integer updateUserid;
    /**
     * 最后一次修改人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String updateUsername;
    /**
     * 最后一次修改时间
     */

    private java.util.Date updateTime;
    /**
     * 最后一次修改人电脑IP, 临时需求改为楼盘热线
     */
    private String updateIp;

    private String shorttel;

    private boolean flag;

    public String getShorttel() {
        return shorttel;
    }

    public void setShorttel(String shorttel) {
        this.shorttel = shorttel;
    }

    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }

    public boolean isFlag() {
        return flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * 获取合同号
     *
     * @return 合同号
     */
    public String getContractCode() {
        return this.contractCode;
    }

    /**
     * 设置合同号
     *
     * @param contractCode 合同号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    /**
     * 获取项目编号
     *
     * @return 项目编号
     */
    public String getProjectCode() {
        return this.projectCode;
    }

    /**
     * 设置项目编号
     *
     * @param projectCode 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 获取项目名称
     *
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置项目名称
     *
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取关联楼盘ID
     *
     * @return 关联楼盘ID
     */
    public Integer getBuildingId() {
        return this.buildingId;
    }

    /**
     * 设置关联楼盘ID
     *
     * @param buildingId 关联楼盘ID
     */
    public void setBuildingId(Integer buildingId) {
        this.buildingId = buildingId;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    /**
     * 获取关联楼盘名称
     *
     * @return 关联楼盘名称
     */
    public String getBuildingName() {
        return this.buildingName;
    }

    /**
     * 设置关联楼盘名称
     *
     * @param buildingName 关联楼盘名称
     */
    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    /**
     * 获取项目状态
     *
     * @return 项目状态
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置项目状态
     *
     * @param status 项目状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取项目经理名称
     *
     * @return 项目经理名称
     */
    public String getManager() {
        return this.manager;
    }

    /**
     * 设置项目经理名称
     *
     * @param manager 项目经理名称
     */
    public void setManager(String manager) {
        this.manager = manager;
    }

    /**
     * 获取物业类型
     *
     * @return 物业类型
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置物业类型
     *
     * @param type 物业类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取开发商
     *
     * @return 开发商
     */
    public String getKfs() {
        return this.kfs;
    }

    /**
     * 设置开发商
     *
     * @param kfs 开发商
     */
    public void setKfs(String kfs) {
        this.kfs = kfs;
    }

    /**
     * 获取地址
     *
     * @return 地址
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * 设置地址
     *
     * @param address 地址
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 设置开盘时间字符串格式
     *
     * @param startTime 开盘时间
     */
    public void setStartTimeStr(String startTime) {
        if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
            try {
                this.startTime = new SimpleDateFormat("yyyy-MM-dd").parse(startTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取开盘时间
     *
     * @return 开盘时间
     */
    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * 设置开盘时间
     *
     * @param startTime 开盘时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 获取房源状况
     *
     * @return 房源状况
     */
    public String getSource() {
        return this.source;
    }

    /**
     * 设置房源状况
     *
     * @param source 房源状况
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * 获取即时销售信息
     *
     * @return 即时销售信息
     */
    public String getJitInfo() {
        return this.jitInfo;
    }

    /**
     * 设置即时销售信息
     *
     * @param jitInfo 即时销售信息
     */
    public void setJitInfo(String jitInfo) {
        this.jitInfo = jitInfo;
    }

    /**
     * 获取佣金标准
     *
     * @return 佣金标准
     */
    public String getHireMoney() {
        return this.hireMoney;
    }

    /**
     * 设置佣金标准
     *
     * @param hireMoney 佣金标准
     */
    public void setHireMoney(String hireMoney) {
        this.hireMoney = hireMoney;
    }

    /**
     * 获取创建人用户ID
     *
     * @return 创建人用户ID
     */
    public Integer getCreateUserid() {
        return this.createUserid;
    }

    /**
     * 设置创建人用户ID
     *
     * @param createUserid 创建人用户ID
     */
    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    /**
     * 获取创建人用户名
     *
     * @return 创建人用户名
     */
    public String getCreateUsername() {
        return this.createUsername;
    }

    /**
     * 设置创建人用户名
     *
     * @param createUsername 创建人用户名
     */
    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取创建人电脑IP
     *
     * @return 创建人电脑IP
     */
    public String getCreateIp() {
        return this.createIp;
    }

    /**
     * 设置创建人电脑IP
     *
     * @param createIp 创建人电脑IP
     */
    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    /**
     * 获取最后一次修改人用户ID
     *
     * @return 最后一次修改人用户ID
     */
    public Integer getUpdateUserid() {
        return this.updateUserid;
    }

    /**
     * 设置最后一次修改人用户ID
     *
     * @param updateUserid 最后一次修改人用户ID
     */
    public void setUpdateUserid(Integer updateUserid) {
        this.updateUserid = updateUserid;
    }

    /**
     * 获取最后一次修改人用户名
     *
     * @return 最后一次修改人用户名
     */
    public String getUpdateUsername() {
        return this.updateUsername;
    }

    /**
     * 设置最后一次修改人用户名
     *
     * @param updateUsername 最后一次修改人用户名
     */
    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     *
     * @return 最后一次修改时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改时间
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后一次修改人电脑IP
     *
     * @return 最后一次修改人电脑IP
     */
    public String getUpdateIp() {
        return this.updateIp;
    }

    /**
     * 设置最后一次修改人电脑IP
     *
     * @param updateIp 最后一次修改人电脑IP
     */
    public void setUpdateIp(String updateIp) {
        this.updateIp = updateIp;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ContractCode",
                getContractCode()).append(
                "ProjectCode", getProjectCode()).append("ProjectName", getProjectName()).append("BuildingId",
                getBuildingId()).append(
                "BuildingName", getBuildingName()).append("Status", getStatus()).append("Manager", getManager()).append(
                "Type", getType()).append("Kfs", getKfs()).append("Address", getAddress()).append("StartTime",
                getStartTime()).append(
                "Source", getSource()).append("JitInfo", getJitInfo()).append("HireMoney", getHireMoney()).append(
                "CreateUserid", getCreateUserid()).append("CreateUsername", getCreateUsername()).append("CreateTime",
                getCreateTime()).append(
                "CreateIp", getCreateIp()).append("UpdateUserid", getUpdateUserid()).append("UpdateUsername",
                getUpdateUsername()).append(
                "UpdateTime", getUpdateTime()).append("UpdateIp", getUpdateIp()).toString();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProjectEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ProjectEntity other = (ProjectEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    public enum ProjectStatus {
        MR(1), ZXZ(2), BJ(3), ZZ(5), LXSHZ(6), SC(7);

        private int status;

        ProjectStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

