/**
 * Description: 客户信息数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:21:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.common.HGSConstant;
import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 客户信息数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public class MarketCustomerEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 活动ID
     */
    @NotNull
    private Integer activeId;

    /**
     * 是否记录过超时操作
     */
    @NotNull
    private Integer isOvertime;

    /**
     * 报名时间
     */
    private String signupTime;

    //报名楼盘ID
    private String signupHouseId;

    //报名楼盘name
    private String signupHouseName;

    //报名来源ID
    private String signupSourceId;

    //报名来源
    private String signupSourceName;

    /**
     * 姓名
     */
    @NotBlank
    @Length(max = 250, message = "长度需要大于0且小于250")
    private String name;

    /**
     * 手机
     */
    @NotBlank
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String phone;

    /**
     * 备用号码1
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone1;

    /**
     * 备用号码2
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone2;

    /**
     * 备用号码3
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone3;

    /**
     * 1 男 0 女 2 未知
     */

    private Integer sex;

    /**
     * 1 线上 2 线下
     */
    @NotNull
    private Integer customerType;

    /**
     * 活动名称－CRM
     */
    @NotBlank
    @Length(max = 300, message = "长度需要大于0且小于300")
    private String actSource;

    /**
     * 初次来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String firstSource;

    /**
     * 最近来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String latestSource;

    /**
     * 最近回访纪录－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCall;

    /**
     * 最近回访结果－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCallResult;

    /**
     * 客户状态 0 待派 1 已派 2 超时 3 放弃
     * 待派：所有可以进行派工的数据，包括超时又返回至当前活动的数据内容。
     * 已派：所有已进行派工的数据。
     * 超时：超时且未派的数据。
     */
    private Integer status;

    /**
     * 创建来源 CRM SYSTEM
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String createSource;

    /**
     * 创建日期
     */
    @NotNull
    private java.util.Date createTime;

    /**
     * 创建人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 购房意向－CRM 3 高 2 中 1低
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String buyIntention;

    /**
     * 最后到访日期
     */

    private java.util.Date lastVisitTime;

    /**
     * 最后回访日期
     */

    private java.util.Date lastCallTime;

    /**
     * 客户经理ID
     */

    private Integer managerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    /**
     * 更新日期
     */
    @NotNull
    private java.util.Date updateTime;

    /**
     * 最后修改人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    /**
     * 城市
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityCode;

    /**
     * 业务条口
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bizPort;

    /**
     * CRM id
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String crmId;

    /**
     * 城市名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityName;

    /**
     * 活动来源ID
     */
    private Integer actSourceId;

    /**
     * 备注
     */
    @Length(max = 600, message = "长度需要大于0且小于600")
    private String remark;

    /**
     * 跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     */
    @NotNull
    private Integer traceStatus;

    /**
     * 是否已推送到CRM，1是0否，保护期同步任务使用
     */
    @Length(max = 2, message = "长度需要大于0且小于2")
    private String crmSync;

    /**
     * hotlineCallTime
     */
    private java.util.Date hotlineCallTime;

    /**
     * hotlineCallSpend
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String hotlineCallSpend;

    /**
     * 入公海时间
     */
    private java.util.Date oceanDate;

    /**
     * 公海无效客户可删除 是否删除 1 是 0 否
     */
    private Integer isDelete;

    /**
     * 移到公海后记录原客户经理名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String lastManager;

    /**
     * bindTime
     */
    private java.util.Date bindTime;

    //customer table id
    private Integer customerId;

    /**
     * 超时量
     */

    private Integer overTimeCount;

    /**
     * 回访量
     */
    private Integer visitBackCount;

    /**
     * 带访量
     */
    private Integer waitVisitCount;

    /**
     * 认购量
     */
    private Integer boughtCount;

    //是否丢弃 1是 0否
    private Integer isabandon;

    //放弃时间
    private Date abandonTime;

    //放弃操作的回访日志ID
    private Integer abandonLogID;

    private Integer isabandonother;

    public Integer getIsabandonother() {
        return isabandonother;
    }

    public void setIsabandonother(Integer isabandonother) {
        this.isabandonother = isabandonother;
    }

    public Integer getIsabandon() {
        return isabandon;
    }

    public void setIsabandon(Integer isabandon) {
        this.isabandon = isabandon;
    }

    public Date getAbandonTime() {
        return abandonTime;
    }

    public void setAbandonTime(Date abandonTime) {
        this.abandonTime = abandonTime;
    }

    public Integer getOverTimeCount() {
        return overTimeCount;
    }

    public void setOverTimeCount(Integer overTimeCount) {
        this.overTimeCount = overTimeCount;
    }

    public Integer getVisitBackCount() {
        return visitBackCount;
    }

    public void setVisitBackCount(Integer visitBackCount) {
        this.visitBackCount = visitBackCount;
    }

    public Integer getWaitVisitCount() {
        return waitVisitCount;
    }

    public void setWaitVisitCount(Integer waitVisitCount) {
        this.waitVisitCount = waitVisitCount;
    }

    public Integer getBoughtCount() {
        return boughtCount;
    }

    public void setBoughtCount(Integer boughtCount) {
        this.boughtCount = boughtCount;
    }

    public CustomerEntity convertCustomer() {
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setCustomerSourceType(HGSConstant.CustomerSourceType.MARKET.getType());
        customerEntity.setActSource(actSource);
        customerEntity.setActSourceId(actSourceId);
        customerEntity.setBizPort(bizPort);
        customerEntity.setBuyIntention(buyIntention);
        customerEntity.setCityCode(cityCode);
        customerEntity.setCityName(cityName);
        customerEntity.setCreater(creater);
        customerEntity.setCreateTime(createTime);
        customerEntity.setUpdater(updater);
        customerEntity.setUpdateTime(updateTime);
        customerEntity.setCrmId(crmId);
        customerEntity.setCrmSync(HGSConstant.CrmSyncStatus.DONE.getType());
        customerEntity.setName(name);
        customerEntity.setPhone(phone);
        customerEntity.setSex(sex);
        customerEntity.setActSource(actSource);
        customerEntity.setFirstSource(firstSource);
//        customerEntity.setCreateSource(HGSConstant.CustomerSourceEnum.CRM.getMsg());
        customerEntity.setCreateSource("CRM拉取");
        customerEntity.setCustomerType(HGSConstant.CustomerTypeEnum.ONLINE.getMsg());
        customerEntity.setLatestSource(latestSource);
        customerEntity.setCrmLatestCall(crmLatestCall);
        customerEntity.setCrmLatestCallResult(crmLatestCallResult);
        customerEntity.setStatus(HGSConstant.CustomerStatusEnum.NORECORD.getStatus());
        customerEntity.setTraceStatus(HGSConstant.TRACE_STATUS_INVALID);
        customerEntity.setIsDelete(0);
        return customerEntity;
    }

    public Integer getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    public String getSignupHouseId() {
        return signupHouseId;
    }

    public void setSignupHouseId(String signupHouseId) {
        this.signupHouseId = signupHouseId;
    }

    public String getSignupHouseName() {
        return signupHouseName;
    }

    public void setSignupHouseName(String signupHouseName) {
        this.signupHouseName = signupHouseName;
    }

    public String getSignupSourceId() {
        return signupSourceId;
    }

    public void setSignupSourceId(String signupSourceId) {
        this.signupSourceId = signupSourceId;
    }

    public String getSignupSourceName() {
        return signupSourceName;
    }

    public void setSignupSourceName(String signupSourceName) {
        this.signupSourceName = signupSourceName;
    }

    /**
     * 设置活动ID
     *
     * @param activeId 活动ID
     */
    public void setActiveId(Integer activeId) {
        this.activeId = activeId;
    }

    /**
     * 获取活动ID
     *
     * @return 活动ID
     */
    public Integer getActiveId() {
        return this.activeId;
    }

    /**
     * 设置是否记录过超时操作
     *
     * @param isOvertime 是否记录过超时操作
     */
    public void setIsOvertime(Integer isOvertime) {
        this.isOvertime = isOvertime;
    }

    /**
     * 获取是否记录过超时操作
     *
     * @return 是否记录过超时操作
     */
    public Integer getIsOvertime() {
        return this.isOvertime;
    }

    /**
     * 设置报名时间
     *
     * @param signupTime 报名时间
     */
    public void setSignupTime(String signupTime) {
        this.signupTime = signupTime;
    }

    /**
     * 获取报名时间
     *
     * @return 报名时间
     */
    public String getSignupTime() {
        return this.signupTime;
    }

    /**
     * 设置姓名
     *
     * @param name 姓名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取姓名
     *
     * @return 姓名
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置手机
     *
     * @param phone 手机
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 获取手机
     *
     * @return 手机
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * 设置备用号码1
     *
     * @param bakPhone1 备用号码1
     */
    public void setBakPhone1(String bakPhone1) {
        this.bakPhone1 = bakPhone1;
    }

    /**
     * 获取备用号码1
     *
     * @return 备用号码1
     */
    public String getBakPhone1() {
        return this.bakPhone1;
    }

    /**
     * 设置备用号码2
     *
     * @param bakPhone2 备用号码2
     */
    public void setBakPhone2(String bakPhone2) {
        this.bakPhone2 = bakPhone2;
    }

    /**
     * 获取备用号码2
     *
     * @return 备用号码2
     */
    public String getBakPhone2() {
        return this.bakPhone2;
    }

    /**
     * 设置备用号码3
     *
     * @param bakPhone3 备用号码3
     */
    public void setBakPhone3(String bakPhone3) {
        this.bakPhone3 = bakPhone3;
    }

    /**
     * 获取备用号码3
     *
     * @return 备用号码3
     */
    public String getBakPhone3() {
        return this.bakPhone3;
    }

    /**
     * 设置1 男 0 女 2 未知
     *
     * @param sex 1 男 0 女 2 未知
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 获取1 男 0 女 2 未知
     *
     * @return 1 男 0 女 2 未知
     */
    public Integer getSex() {
        return this.sex;
    }

    /**
     * 设置1 线上 2 线下
     *
     * @param customerType 1 线上 2 线下
     */
    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    /**
     * 获取1 线上 2 线下
     *
     * @return 1 线上 2 线下
     */
    public Integer getCustomerType() {
        return this.customerType;
    }

    /**
     * 设置活动来源－CRM
     *
     * @param actSource 活动来源－CRM
     */
    public void setActSource(String actSource) {
        this.actSource = actSource;
    }

    /**
     * 获取活动来源－CRM
     *
     * @return 活动来源－CRM
     */
    public String getActSource() {
        return this.actSource;
    }

    /**
     * 设置初次来源-CRM
     *
     * @param firstSource 初次来源-CRM
     */
    public void setFirstSource(String firstSource) {
        this.firstSource = firstSource;
    }

    /**
     * 获取初次来源-CRM
     *
     * @return 初次来源-CRM
     */
    public String getFirstSource() {
        return this.firstSource;
    }

    /**
     * 设置最近来源-CRM
     *
     * @param latestSource 最近来源-CRM
     */
    public void setLatestSource(String latestSource) {
        this.latestSource = latestSource;
    }

    /**
     * 获取最近来源-CRM
     *
     * @return 最近来源-CRM
     */
    public String getLatestSource() {
        return this.latestSource;
    }

    /**
     * 设置最近回访纪录－CRM
     *
     * @param crmLatestCall 最近回访纪录－CRM
     */
    public void setCrmLatestCall(String crmLatestCall) {
        this.crmLatestCall = crmLatestCall;
    }

    /**
     * 获取最近回访纪录－CRM
     *
     * @return 最近回访纪录－CRM
     */
    public String getCrmLatestCall() {
        return this.crmLatestCall;
    }

    /**
     * 设置最近回访结果－CRM
     *
     * @param crmLatestCallResult 最近回访结果－CRM
     */
    public void setCrmLatestCallResult(String crmLatestCallResult) {
        this.crmLatestCallResult = crmLatestCallResult;
    }

    /**
     * 获取最近回访结果－CRM
     *
     * @return 最近回访结果－CRM
     */
    public String getCrmLatestCallResult() {
        return this.crmLatestCallResult;
    }

    /**
     * 设置客户状态
     *
     * @param status 客户状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取客户状态
     *
     * @return 客户状态
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置创建来源 CRM SYSTEM
     *
     * @param createSource 创建来源 CRM SYSTEM
     */
    public void setCreateSource(String createSource) {
        this.createSource = createSource;
    }

    /**
     * 获取创建来源 CRM SYSTEM
     *
     * @return 创建来源 CRM SYSTEM
     */
    public String getCreateSource() {
        return this.createSource;
    }

    /**
     * 设置创建日期
     *
     * @param createTime 创建日期
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建日期字符串格式
     *
     * @param createTime 创建日期
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建日期
     *
     * @return 创建日期
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建人
     *
     * @param creater 创建人
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取创建人
     *
     * @return 创建人
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置购房意向－CRM 3 高 2 中 1低
     *
     * @param buyIntention 购房意向－CRM 3 高 2 中 1低
     */
    public void setBuyIntention(String buyIntention) {
        this.buyIntention = buyIntention;
    }

    /**
     * 获取购房意向－CRM 3 高 2 中 1低
     *
     * @return 购房意向－CRM 3 高 2 中 1低
     */
    public String getBuyIntention() {
        return this.buyIntention;
    }

    /**
     * 设置最后到访日期
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTime(java.util.Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    /**
     * 设置最后到访日期字符串格式
     *
     * @param lastVisitTime 最后到访日期
     */
    public void setLastVisitTimeStr(String lastVisitTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastVisitTime)) {
            try {
                this.lastVisitTime = java.text.DateFormat.getDateTimeInstance().parse(lastVisitTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后到访日期
     *
     * @return 最后到访日期
     */
    public java.util.Date getLastVisitTime() {
        return this.lastVisitTime;
    }

    /**
     * 设置最后回访日期
     *
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTime(java.util.Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    /**
     * 设置最后回访日期字符串格式
     *
     * @param lastCallTime 最后回访日期
     */
    public void setLastCallTimeStr(String lastCallTime) {
        if (!com.house365.web.util.StringUtils.isBlank(lastCallTime)) {
            try {
                this.lastCallTime = java.text.DateFormat.getDateTimeInstance().parse(lastCallTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后回访日期
     *
     * @return 最后回访日期
     */
    public java.util.Date getLastCallTime() {
        return this.lastCallTime;
    }

    /**
     * 设置客户经理ID
     *
     * @param managerId 客户经理ID
     */
    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取客户经理ID
     *
     * @return 客户经理ID
     */
    public Integer getManagerId() {
        return this.managerId;
    }

    /**
     * 设置客户经理姓名
     *
     * @param managerName 客户经理姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 获取客户经理姓名
     *
     * @return 客户经理姓名
     */
    public String getManagerName() {
        return this.managerName;
    }

    /**
     * 设置更新日期
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置更新日期字符串格式
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新日期
     *
     * @return 更新日期
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后修改人
     *
     * @param updater 最后修改人
     */
    public void setUpdater(String updater) {
        this.updater = updater;
    }

    /**
     * 获取最后修改人
     *
     * @return 最后修改人
     */
    public String getUpdater() {
        return this.updater;
    }

    /**
     * 设置城市
     *
     * @param cityCode 城市
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /**
     * 获取城市
     *
     * @return 城市
     */
    public String getCityCode() {
        return this.cityCode;
    }

    /**
     * 设置业务条口
     *
     * @param bizPort 业务条口
     */
    public void setBizPort(String bizPort) {
        this.bizPort = bizPort;
    }

    /**
     * 获取业务条口
     *
     * @return 业务条口
     */
    public String getBizPort() {
        return this.bizPort;
    }

    /**
     * 设置CRM id
     *
     * @param crmId CRM id
     */
    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    /**
     * 获取CRM id
     *
     * @return CRM id
     */
    public String getCrmId() {
        return this.crmId;
    }

    /**
     * 设置城市名
     *
     * @param cityName 城市名
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名
     *
     * @return 城市名
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置活动来源ID
     *
     * @param actSourceId 活动来源ID
     */
    public void setActSourceId(Integer actSourceId) {
        this.actSourceId = actSourceId;
    }

    /**
     * 获取活动来源ID
     *
     * @return 活动来源ID
     */
    public Integer getActSourceId() {
        return this.actSourceId;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取备注
     *
     * @return 备注
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     *
     * @param traceStatus 跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     */
    public void setTraceStatus(Integer traceStatus) {
        this.traceStatus = traceStatus;
    }

    /**
     * 获取跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     *
     * @return 跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     */
    public Integer getTraceStatus() {
        return this.traceStatus;
    }

    /**
     * 设置是否已推送到CRM，1是0否，保护期同步任务使用
     *
     * @param crmSync 是否已推送到CRM，1是0否，保护期同步任务使用
     */
    public void setCrmSync(String crmSync) {
        this.crmSync = crmSync;
    }

    /**
     * 获取是否已推送到CRM，1是0否，保护期同步任务使用
     *
     * @return 是否已推送到CRM，1是0否，保护期同步任务使用
     */
    public String getCrmSync() {
        return this.crmSync;
    }

    /**
     * 设置hotlineCallTime
     *
     * @param hotlineCallTime hotlineCallTime
     */
    public void setHotlineCallTime(java.util.Date hotlineCallTime) {
        this.hotlineCallTime = hotlineCallTime;
    }

    /**
     * 设置hotlineCallTime字符串格式
     *
     * @param hotlineCallTime hotlineCallTime
     */
    public void setHotlineCallTimeStr(String hotlineCallTime) {
        if (!com.house365.web.util.StringUtils.isBlank(hotlineCallTime)) {
            try {
                this.hotlineCallTime = java.text.DateFormat.getDateTimeInstance().parse(hotlineCallTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取hotlineCallTime
     *
     * @return hotlineCallTime
     */
    public java.util.Date getHotlineCallTime() {
        return this.hotlineCallTime;
    }

    /**
     * 设置hotlineCallSpend
     *
     * @param hotlineCallSpend hotlineCallSpend
     */
    public void setHotlineCallSpend(String hotlineCallSpend) {
        this.hotlineCallSpend = hotlineCallSpend;
    }

    /**
     * 获取hotlineCallSpend
     *
     * @return hotlineCallSpend
     */
    public String getHotlineCallSpend() {
        return this.hotlineCallSpend;
    }

    /**
     * 设置入公海时间
     *
     * @param oceanDate 入公海时间
     */
    public void setOceanDate(java.util.Date oceanDate) {
        this.oceanDate = oceanDate;
    }

    /**
     * 设置入公海时间字符串格式
     *
     * @param oceanDate 入公海时间
     */
    public void setOceanDateStr(String oceanDate) {
        if (!com.house365.web.util.StringUtils.isBlank(oceanDate)) {
            try {
                this.oceanDate = java.text.DateFormat.getDateTimeInstance().parse(oceanDate);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取入公海时间
     *
     * @return 入公海时间
     */
    public java.util.Date getOceanDate() {
        return this.oceanDate;
    }

    /**
     * 设置公海无效客户可删除 是否删除 1 是 0 否
     *
     * @param isDelete 公海无效客户可删除 是否删除 1 是 0 否
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    /**
     * 获取公海无效客户可删除 是否删除 1 是 0 否
     *
     * @return 公海无效客户可删除 是否删除 1 是 0 否
     */
    public Integer getIsDelete() {
        return this.isDelete;
    }

    /**
     * 设置移到公海后记录原客户经理名
     *
     * @param lastManager 移到公海后记录原客户经理名
     */
    public void setLastManager(String lastManager) {
        this.lastManager = lastManager;
    }

    /**
     * 获取移到公海后记录原客户经理名
     *
     * @return 移到公海后记录原客户经理名
     */
    public String getLastManager() {
        return this.lastManager;
    }

    /**
     * 设置bindTime
     *
     * @param bindTime bindTime
     */
    public void setBindTime(java.util.Date bindTime) {
        this.bindTime = bindTime;
    }

    /**
     * 设置bindTime字符串格式
     *
     * @param bindTime bindTime
     */
    public void setBindTimeStr(String bindTime) {
        if (!com.house365.web.util.StringUtils.isBlank(bindTime)) {
            try {
                this.bindTime = java.text.DateFormat.getDateTimeInstance().parse(bindTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取bindTime
     *
     * @return bindTime
     */
    public java.util.Date getBindTime() {
        return this.bindTime;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ActiveId",
                getActiveId()).append(
                "IsOvertime", getIsOvertime()).append("SignupTime", getSignupTime()).append("Name", getName()).append(
                "Phone", getPhone()).append("BakPhone1", getBakPhone1()).append("BakPhone2", getBakPhone2()).append(
                "BakPhone3", getBakPhone3()).append("Sex", getSex()).append("CustomerType", getCustomerType()).append(
                "ActSource", getActSource()).append("FirstSource", getFirstSource()).append("LatestSource",
                getLatestSource()).append(
                "CrmLatestCall", getCrmLatestCall()).append("CrmLatestCallResult", getCrmLatestCallResult()).append(
                "Status", getStatus()).append("CreateSource", getCreateSource()).append("CreateTime",
                getCreateTime()).append("Creater",
                getCreater()).append(
                "BuyIntention", getBuyIntention()).append("LastVisitTime", getLastVisitTime()).append("LastCallTime",
                getLastCallTime()).append(
                "ManagerId", getManagerId()).append("ManagerName", getManagerName()).append("UpdateTime",
                getUpdateTime()).append(
                "Updater", getUpdater()).append("CityCode", getCityCode()).append("BizPort", getBizPort()).append("CrmId",
                getCrmId()).append(
                "CityName", getCityName()).append("ActSourceId", getActSourceId()).append("Remark", getRemark()).append(
                "TraceStatus", getTraceStatus()).append("CrmSync", getCrmSync()).append("HotlineCallTime",
                getHotlineCallTime()).append(
                "HotlineCallSpend", getHotlineCallSpend()).append("OceanDate", getOceanDate()).append("IsDelete",
                getIsDelete()).append(
                "LastManager", getLastManager()).append("BindTime", getBindTime()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MarketCustomerEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MarketCustomerEntity other = (MarketCustomerEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    public void setAbandonLogID(Integer abandonLogID) {
        this.abandonLogID = abandonLogID;
    }

    public Integer getAbandonLogID() {
        return abandonLogID;
    }
}

