package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 外部客户回访记录实体
 *
 * @author Created by Administrator on 2020/6/30.
 */
public class ExternalCustomerCallbackLogEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * 客户ID
     */
    @NotNull
    private Integer customerId;

    /**
     * 客户经理ID
     */
    private Integer managerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    private String phone;

    /**
     * 回访内容
     */
    @NotBlank
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String content;

    @NotNull
    private Date createTime;

    /**
     * 回访结果
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String result;

    /**
     * 创建人姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 录音记录id
     */
    private Integer callRecordId;

    /**
     * 录音文件名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String callRecordName;

    /**
     * 录音总时长
     */
    private Integer callRecordDuration;

    private Integer source;

    public Integer getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public Integer getCallRecordId() {
        return callRecordId;
    }

    public void setCallRecordId(Integer callRecordId) {
        this.callRecordId = callRecordId;
    }

    public String getCallRecordName() {
        return callRecordName;
    }

    public void setCallRecordName(String callRecordName) {
        this.callRecordName = callRecordName;
    }

    public Integer getCallRecordDuration() {
        return callRecordDuration;
    }

    public void setCallRecordDuration(Integer callRecordDuration) {
        this.callRecordDuration = callRecordDuration;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
}
