/**
 * Description: 客户活动来源数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 08:58:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 客户活动来源数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public class CustomerSourceEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    @NotBlank
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String sourceName;

    /**
     * sort
     */
    @NotNull
    private Integer sort;

    /**
     * createTime
     */
    private java.util.Date createTime;

    /**
     * creater
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * city
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String city;

    @NotNull
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String source;

    //1正常0删除
    private Integer status;

    private int type;

    //columns END

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * 设置sourceName
     *
     * @param sourceName sourceName
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 获取sourceName
     *
     * @return sourceName
     */
    public String getSourceName() {
        return this.sourceName;
    }

    /**
     * 设置sort
     *
     * @param sort sort
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取sort
     *
     * @return sort
     */
    public Integer getSort() {
        return this.sort;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
//        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
//            try {
//                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
//            } catch (java.text.ParseException ex) {
//                ex.printStackTrace();
//            }
//        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置creater
     *
     * @param creater creater
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取creater
     *
     * @return creater
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置city
     *
     * @param city city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取city
     *
     * @return city
     */
    public String getCity() {
        return this.city;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("SourceName",
                getSourceName()).append(
                "Sort", getSort()).append("CreateTime", getCreateTime()).append("Creater", getCreater()).append("City",
                getCity()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerSourceEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CustomerSourceEntity other = (CustomerSourceEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

